/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.lucko.helper.Schedulers;
import me.lucko.helper.promise.Promise;
import me.lucko.helper.sql.batch.BatchBuilder;
import me.lucko.helper.sql.external.hikari.HikariDataSource;
import me.lucko.helper.sql.streams.SqlStream;
import me.lucko.helper.sql.streams.util.SqlConsumer;
import me.lucko.helper.sql.streams.util.SqlFunction;
import me.lucko.helper.terminable.Terminable;
import org.intellij.lang.annotations.Language;

public interface Sql
extends Terminable {
    @Nonnull
    public HikariDataSource getHikari();

    @Nonnull
    public Connection getConnection() throws SQLException;

    @Nonnull
    public SqlStream stream();

    @Nonnull
    default public Promise<Void> executeAsync(@Nonnull @Language(value="MySQL") String statement) {
        return Schedulers.async().run(() -> this.execute(statement));
    }

    default public void execute(@Nonnull @Language(value="MySQL") String statement) {
        this.execute(statement, stmt -> {});
    }

    @Nonnull
    default public Promise<Void> executeAsync(@Nonnull @Language(value="MySQL") String statement, @Nonnull SqlConsumer<PreparedStatement> preparer) {
        return Schedulers.async().run(() -> this.execute(statement, preparer));
    }

    public void execute(@Nonnull @Language(value="MySQL") String var1, @Nonnull SqlConsumer<PreparedStatement> var2);

    default public <R> Promise<Optional<R>> queryAsync(@Nonnull @Language(value="MySQL") String query, @Nonnull SqlFunction<ResultSet, R> handler) {
        return Schedulers.async().supply(() -> this.query(query, handler));
    }

    default public <R> Optional<R> query(@Nonnull @Language(value="MySQL") String query, @Nonnull SqlFunction<ResultSet, R> handler) {
        return this.query(query, stmt -> {}, handler);
    }

    default public <R> Promise<Optional<R>> queryAsync(@Nonnull @Language(value="MySQL") String query, @Nonnull SqlConsumer<PreparedStatement> preparer, @Nonnull SqlFunction<ResultSet, R> handler) {
        return Schedulers.async().supply(() -> this.query(query, preparer, handler));
    }

    public <R> Optional<R> query(@Nonnull @Language(value="MySQL") String var1, @Nonnull SqlConsumer<PreparedStatement> var2, @Nonnull SqlFunction<ResultSet, R> var3);

    default public Promise<Void> executeBatchAsync(@Nonnull BatchBuilder builder) {
        return Schedulers.async().run(() -> this.executeBatch(builder));
    }

    public void executeBatch(@Nonnull BatchBuilder var1);

    public BatchBuilder batch(@Nonnull @Language(value="MySQL") String var1);
}

