/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.bukkit.configuration.ConfigurationSection;

public final class DatabaseCredentials {
    private final String address;
    private final int port;
    private final String database;
    private final String username;
    private final String password;

    @Nonnull
    public static DatabaseCredentials of(@Nonnull String address, int port, @Nonnull String database, @Nonnull String username, @Nonnull String password) {
        return new DatabaseCredentials(address, port, database, username, password);
    }

    @Nonnull
    public static DatabaseCredentials fromConfig(@Nonnull ConfigurationSection config) {
        return DatabaseCredentials.of(config.getString("address", "localhost"), config.getInt("port", 3306), config.getString("database", "minecraft"), config.getString("username", "root"), config.getString("password", "passw0rd"));
    }

    private DatabaseCredentials(@Nonnull String address, int port, @Nonnull String database, @Nonnull String username, @Nonnull String password) {
        this.address = Objects.requireNonNull(address);
        this.port = port;
        this.database = Objects.requireNonNull(database);
        this.username = Objects.requireNonNull(username);
        this.password = Objects.requireNonNull(password);
    }

    @Nonnull
    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    @Nonnull
    public String getDatabase() {
        return this.database;
    }

    @Nonnull
    public String getUsername() {
        return this.username;
    }

    @Nonnull
    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseCredentials)) {
            return false;
        }
        DatabaseCredentials other = (DatabaseCredentials)o;
        return this.getAddress().equals(other.getAddress()) && this.getPort() == other.getPort() && this.getDatabase().equals(other.getDatabase()) && this.getUsername().equals(other.getUsername()) && this.getPassword().equals(other.getPassword());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + this.getAddress().hashCode();
        result = result * 59 + this.getDatabase().hashCode();
        result = result * 59 + this.getUsername().hashCode();
        result = result * 59 + this.getPassword().hashCode();
        return result;
    }

    public String toString() {
        return "DatabaseCredentials(address=" + this.getAddress() + ", port=" + this.getPort() + ", database=" + this.getDatabase() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }
}

