/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol;

import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import me.lucko.helper.sql.external.mariadb.jdbc.HostAddress;
import me.lucko.helper.sql.external.mariadb.jdbc.UrlParser;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.failover.FailoverProxy;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.failover.impl.MastersSlavesListener;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.failover.tools.SearchFilter;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol.MasterProtocol;

public class MastersSlavesProtocol
extends MasterProtocol {
    boolean masterConnection = false;
    boolean mustBeMasterConnection = false;

    public MastersSlavesProtocol(UrlParser url, ReentrantLock lock) {
        super(url, lock);
    }

    public static void loop(MastersSlavesListener listener, List<HostAddress> addresses, SearchFilter searchFilter) throws SQLException {
        ArrayDeque<HostAddress> loopAddresses = new ArrayDeque<HostAddress>(!addresses.isEmpty() ? addresses : listener.getBlacklistKeys());
        if (loopAddresses.isEmpty()) {
            loopAddresses.addAll(listener.getUrlParser().getHostAddresses());
        }
        int maxConnectionTry = listener.getRetriesAllDown();
        SQLException lastQueryException = null;
        while (!loopAddresses.isEmpty() || !searchFilter.isFailoverLoop() && maxConnectionTry > 0) {
            MastersSlavesProtocol protocol = MastersSlavesProtocol.getNewProtocol(listener.getProxy(), listener.getUrlParser());
            if (listener.isExplicitClosed() || !listener.isSecondaryHostFailReconnect() && !listener.isMasterHostFailReconnect()) {
                return;
            }
            --maxConnectionTry;
            try {
                HostAddress host = loopAddresses.pollFirst();
                if (host == null) {
                    loopAddresses.addAll(listener.getUrlParser().getHostAddresses());
                    host = loopAddresses.pollFirst();
                }
                protocol.setHostAddress(host);
                protocol.connect();
                if (listener.isExplicitClosed()) {
                    protocol.close();
                    return;
                }
                listener.removeFromBlacklist(protocol.getHostAddress());
                if (listener.isMasterHostFailReconnect() && protocol.isMasterConnection()) {
                    if (MastersSlavesProtocol.foundMaster(listener, protocol, searchFilter)) {
                        return;
                    }
                } else if (listener.isSecondaryHostFailReconnect() && !protocol.isMasterConnection()) {
                    if (MastersSlavesProtocol.foundSecondary(listener, protocol, searchFilter)) {
                        return;
                    }
                } else {
                    protocol.close();
                }
            }
            catch (SQLException e) {
                lastQueryException = e;
                listener.addToBlacklist(protocol.getHostAddress());
            }
            if (!listener.isMasterHostFailReconnect() && !listener.isSecondaryHostFailReconnect()) {
                return;
            }
            if (!loopAddresses.isEmpty() || searchFilter.isFailoverLoop() || maxConnectionTry <= 0) continue;
            loopAddresses = new ArrayDeque<HostAddress>(listener.getBlacklistKeys());
        }
        if (listener.isMasterHostFailReconnect() || listener.isSecondaryHostFailReconnect()) {
            String error = "No active connection found for replica";
            if (listener.isMasterHostFailReconnect()) {
                error = "No active connection found for master";
            }
            if (lastQueryException != null) {
                throw new SQLException(error + " : " + lastQueryException.getMessage(), lastQueryException.getSQLState(), lastQueryException.getErrorCode(), lastQueryException);
            }
            throw new SQLException(error);
        }
    }

    protected static boolean foundMaster(MastersSlavesListener listener, MastersSlavesProtocol protocol, SearchFilter searchFilter) {
        protocol.setMustBeMasterConnection(true);
        if (listener.isMasterHostFailReconnect()) {
            listener.foundActiveMaster(protocol);
        } else {
            protocol.close();
        }
        if (!listener.isSecondaryHostFailReconnect()) {
            return true;
        }
        return listener.isExplicitClosed() || searchFilter.isFineIfFoundOnlyMaster() || !listener.isSecondaryHostFailReconnect();
    }

    protected static boolean foundSecondary(MastersSlavesListener listener, MastersSlavesProtocol protocol, SearchFilter searchFilter) throws SQLException {
        protocol.setMustBeMasterConnection(false);
        if (listener.isSecondaryHostFailReconnect()) {
            listener.foundActiveSecondary(protocol);
        } else {
            protocol.close();
        }
        if (!listener.isMasterHostFailReconnect()) {
            return true;
        }
        return listener.isExplicitClosed() || searchFilter.isFineIfFoundOnlySlave() || !listener.isMasterHostFailReconnect();
    }

    public static MastersSlavesProtocol getNewProtocol(FailoverProxy proxy, UrlParser urlParser) {
        MastersSlavesProtocol newProtocol = new MastersSlavesProtocol(urlParser, proxy.lock);
        newProtocol.setProxy(proxy);
        return newProtocol;
    }

    @Override
    public boolean mustBeMasterConnection() {
        return this.mustBeMasterConnection;
    }

    public void setMustBeMasterConnection(boolean mustBeMasterConnection) {
        this.mustBeMasterConnection = mustBeMasterConnection;
    }
}

