/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol;

import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.Callable;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.dao.Results;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.ComStmtPrepare;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol.AbstractMultiSend;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol.AsyncMultiReadResult;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol.Protocol;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.BulkStatus;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.SqlStates;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.dao.PrepareResult;

public class AsyncMultiRead
implements Callable<AsyncMultiReadResult> {
    private final ComStmtPrepare comStmtPrepare;
    private final BulkStatus status;
    private final int sendCmdInitialCounter;
    private final Protocol protocol;
    private final boolean readPrepareStmtResult;
    private final AbstractMultiSend bulkSend;
    private final List<ParameterHolder[]> parametersList;
    private final List<String> queries;
    private Results results;
    private int paramCount;
    private AsyncMultiReadResult asyncMultiReadResult;

    public AsyncMultiRead(ComStmtPrepare comStmtPrepare, BulkStatus status, Protocol protocol, boolean readPrepareStmtResult, AbstractMultiSend bulkSend, int paramCount, Results results, List<ParameterHolder[]> parametersList, List<String> queries, PrepareResult prepareResult) {
        this.comStmtPrepare = comStmtPrepare;
        this.status = status;
        this.sendCmdInitialCounter = status.sendCmdCounter - 1;
        this.protocol = protocol;
        this.readPrepareStmtResult = readPrepareStmtResult;
        this.bulkSend = bulkSend;
        this.paramCount = paramCount;
        this.results = results;
        this.parametersList = parametersList;
        this.queries = queries;
        this.asyncMultiReadResult = new AsyncMultiReadResult(prepareResult);
    }

    @Override
    public AsyncMultiReadResult call() throws Exception {
        if (this.protocol.getOptions().socketTimeout != null) {
            this.protocol.changeSocketSoTimeout(0);
        }
        if (this.readPrepareStmtResult) {
            try {
                this.asyncMultiReadResult.setPrepareResult(this.comStmtPrepare.read(this.protocol.getReader(), this.protocol.isEofDeprecated()));
            }
            catch (SQLException queryException) {
                this.asyncMultiReadResult.setException(queryException);
            }
        }
        int counter = 0;
        block4: while (!this.status.sendEnded || counter < this.status.sendSubCmdCounter) {
            while (counter < this.status.sendSubCmdCounter) {
                block9: {
                    try {
                        this.protocol.getResult(this.results);
                    }
                    catch (SQLException qex) {
                        if (this.asyncMultiReadResult.getException() != null) break block9;
                        this.asyncMultiReadResult.setException(this.bulkSend.handleResultException(qex, this.results, this.parametersList, this.queries, counter, this.sendCmdInitialCounter, this.paramCount, this.asyncMultiReadResult.getPrepareResult()));
                    }
                }
                ++counter;
                if (!Thread.currentThread().isInterrupted()) continue;
                this.asyncMultiReadResult.setException(new SQLException("Interrupted reading responses ", SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), -1));
                continue block4;
            }
        }
        if (this.protocol.getOptions().socketTimeout != null) {
            this.protocol.changeSocketSoTimeout(this.protocol.getOptions().socketTimeout);
        }
        return this.asyncMultiReadResult;
    }
}

