/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLTimeoutException;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.ReentrantLock;
import me.lucko.helper.sql.external.mariadb.jdbc.LocalInfileInterceptor;
import me.lucko.helper.sql.external.mariadb.jdbc.MariaDbConnection;
import me.lucko.helper.sql.external.mariadb.jdbc.MariaDbStatement;
import me.lucko.helper.sql.external.mariadb.jdbc.UrlParser;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.ColumnType;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.Buffer;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.ErrorPacket;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.dao.Results;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.resultset.ColumnInformation;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.resultset.SelectResultSet;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.ComQuery;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.ComStmtExecute;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.ComStmtPrepare;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.SendChangeDbPacket;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.output.PacketOutputStream;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.logging.Logger;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.logging.LoggerFactory;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol.AbstractConnectProtocol;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol.AbstractMultiSend;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol.MasterProtocol;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol.Protocol;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.BulkStatus;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.LogQueryTool;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.SqlStates;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.Utils;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.dao.ClientPrepareResult;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.dao.PrepareResult;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.dao.ServerPrepareResult;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.exceptions.ExceptionMapper;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.exceptions.MaxAllowedPacketException;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.scheduler.SchedulerServiceProviderHolder;

public class AbstractQueryProtocol
extends AbstractConnectProtocol
implements Protocol {
    public static ThreadPoolExecutor readScheduler = null;
    private static Logger logger = LoggerFactory.getLogger(AbstractQueryProtocol.class);
    private int transactionIsolationLevel = 0;
    private InputStream localInfileInputStream;
    private long maxRows;
    private volatile int statementIdToRelease = -1;
    private FutureTask activeFutureTask = null;
    private LogQueryTool logQuery;
    private boolean interrupted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public AbstractQueryProtocol(UrlParser urlParser, ReentrantLock lock) {
        super(urlParser, lock);
        if (this.options.useBatchMultiSend.booleanValue() && readScheduler == null) {
            Class<AbstractQueryProtocol> clazz = AbstractQueryProtocol.class;
            // MONITORENTER : me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol.AbstractQueryProtocol.class
            if (readScheduler == null) {
                readScheduler = SchedulerServiceProviderHolder.getBulkScheduler();
            }
            // MONITOREXIT : clazz
        }
        this.logQuery = new LogQueryTool(this.options);
    }

    @Override
    public void executeQuery(String sql) throws SQLException {
        this.executeQuery(this.isMasterConnection(), new Results(), sql);
    }

    @Override
    public void executeQuery(boolean mustExecuteOnMaster, Results results, String sql) throws SQLException {
        this.cmdPrologue();
        try {
            this.writer.startPacket(0);
            this.writer.write(3);
            this.writer.write(sql);
            this.writer.flush();
            this.getResult(results);
        }
        catch (SQLException sqlException) {
            throw this.logQuery.exceptionWithQuery(sql, sqlException);
        }
        catch (IOException e) {
            throw this.handleIoException(e);
        }
    }

    @Override
    public void executeQuery(boolean mustExecuteOnMaster, Results results, String sql, Charset charset) throws SQLException {
        this.cmdPrologue();
        try {
            this.writer.startPacket(0);
            this.writer.write(3);
            this.writer.write(sql.getBytes(charset));
            this.writer.flush();
            this.getResult(results);
        }
        catch (SQLException sqlException) {
            throw this.logQuery.exceptionWithQuery(sql, sqlException);
        }
        catch (IOException e) {
            throw this.handleIoException(e);
        }
    }

    @Override
    public void executeQuery(boolean mustExecuteOnMaster, Results results, ClientPrepareResult clientPrepareResult, ParameterHolder[] parameters) throws SQLException {
        this.cmdPrologue();
        try {
            if (clientPrepareResult.getParamCount() == 0 && !clientPrepareResult.isQueryMultiValuesRewritable()) {
                if (clientPrepareResult.getQueryParts().size() == 1) {
                    ComQuery.sendDirect(this.writer, clientPrepareResult.getQueryParts().get(0));
                } else {
                    ComQuery.sendMultiDirect(this.writer, clientPrepareResult.getQueryParts());
                }
            } else {
                this.writer.startPacket(0);
                ComQuery.sendSubCmd(this.writer, clientPrepareResult, parameters);
                this.writer.flush();
            }
            this.getResult(results);
        }
        catch (SQLException queryException) {
            throw this.logQuery.exceptionWithQuery(parameters, queryException, clientPrepareResult);
        }
        catch (IOException e) {
            throw this.handleIoException(e);
        }
    }

    @Override
    public void executeQuery(boolean mustExecuteOnMaster, Results results, ClientPrepareResult clientPrepareResult, ParameterHolder[] parameters, int queryTimeout) throws SQLException {
        this.cmdPrologue();
        try {
            if (clientPrepareResult.getParamCount() == 0 && !clientPrepareResult.isQueryMultiValuesRewritable()) {
                if (clientPrepareResult.getQueryParts().size() == 1) {
                    ComQuery.sendDirect(this.writer, clientPrepareResult.getQueryParts().get(0), queryTimeout);
                } else {
                    ComQuery.sendMultiDirect(this.writer, clientPrepareResult.getQueryParts(), queryTimeout);
                }
            } else {
                this.writer.startPacket(0);
                ComQuery.sendSubCmd(this.writer, clientPrepareResult, parameters);
                this.writer.flush();
            }
            this.getResult(results);
        }
        catch (SQLException queryException) {
            throw this.logQuery.exceptionWithQuery(parameters, queryException, clientPrepareResult);
        }
        catch (IOException e) {
            throw this.handleIoException(e);
        }
    }

    @Override
    public void executeBatchMulti(boolean mustExecuteOnMaster, Results results, final ClientPrepareResult clientPrepareResult, final List<ParameterHolder[]> parametersList) throws SQLException {
        this.cmdPrologue();
        new AbstractMultiSend(this, this.writer, results, clientPrepareResult, parametersList){

            @Override
            public void sendCmd(PacketOutputStream writer, Results results, List<ParameterHolder[]> parametersList2, List<String> queries, int paramCount, BulkStatus status, PrepareResult prepareResult) throws SQLException, IOException {
                ParameterHolder[] parameters = parametersList2.get(status.sendCmdCounter);
                writer.startPacket(0);
                ComQuery.sendSubCmd(writer, clientPrepareResult, parameters);
                writer.flush();
            }

            @Override
            public SQLException handleResultException(SQLException qex, Results results, List<ParameterHolder[]> parametersList2, List<String> queries, int currentCounter, int sendCmdCounter, int paramCount, PrepareResult prepareResult) throws SQLException {
                int counter = results.getCurrentStatNumber() - 1;
                ParameterHolder[] parameters = parametersList2.get(counter);
                List<byte[]> queryParts = clientPrepareResult.getQueryParts();
                String sql = new String(queryParts.get(0));
                for (int i = 0; i < paramCount; ++i) {
                    sql = sql + parameters[i].toString() + new String(queryParts.get(i + 1));
                }
                return AbstractQueryProtocol.this.logQuery.exceptionWithQuery(sql, qex);
            }

            @Override
            public int getParamCount() {
                return clientPrepareResult.getQueryParts().size() - 1;
            }

            @Override
            public int getTotalExecutionNumber() {
                return parametersList.size();
            }
        }.executeBatch();
    }

    @Override
    public void executeBatch(boolean mustExecuteOnMaster, Results results, final List<String> queries) throws SQLException {
        this.cmdPrologue();
        if (!this.options.useBatchMultiSend.booleanValue()) {
            String sql = null;
            SQLException exception = null;
            for (int i = 0; i < queries.size() && !this.isInterrupted(); ++i) {
                try {
                    sql = queries.get(i);
                    this.writer.startPacket(0);
                    this.writer.write(3);
                    this.writer.write(sql);
                    this.writer.flush();
                    this.getResult(results);
                    continue;
                }
                catch (SQLException sqlException) {
                    if (exception != null) continue;
                    exception = this.logQuery.exceptionWithQuery(sql, sqlException);
                    if (this.options.continueBatchOnError) continue;
                    throw exception;
                }
                catch (IOException e) {
                    if (exception != null) continue;
                    exception = this.handleIoException(e);
                    if (this.options.continueBatchOnError) continue;
                    throw exception;
                }
            }
            this.stopIfInterrupted();
            if (exception != null) {
                throw exception;
            }
            return;
        }
        new AbstractMultiSend(this, this.writer, results, queries){

            @Override
            public void sendCmd(PacketOutputStream pos, Results results, List<ParameterHolder[]> parametersList, List<String> queries2, int paramCount, BulkStatus status, PrepareResult prepareResult) throws SQLException, IOException {
                String sql = queries2.get(status.sendCmdCounter);
                pos.startPacket(0);
                pos.write(3);
                pos.write(sql);
                pos.flush();
            }

            @Override
            public SQLException handleResultException(SQLException qex, Results results, List<ParameterHolder[]> parametersList, List<String> queries2, int currentCounter, int sendCmdCounter, int paramCount, PrepareResult prepareResult) throws SQLException {
                String sql = queries2.get(currentCounter + sendCmdCounter);
                return AbstractQueryProtocol.this.logQuery.exceptionWithQuery(sql, qex);
            }

            @Override
            public int getParamCount() {
                return -1;
            }

            @Override
            public int getTotalExecutionNumber() {
                return queries.size();
            }
        }.executeBatch();
    }

    @Override
    public ServerPrepareResult prepare(String sql, boolean executeOnMaster) throws SQLException {
        this.cmdPrologue();
        this.lock.lock();
        try {
            ServerPrepareResult result;
            String key;
            ServerPrepareResult pr;
            if (this.options.cachePrepStmts && (pr = (ServerPrepareResult)this.serverPrepareStatementCache.get(key = this.database + "-" + sql)) != null && pr.incrementShareCounter()) {
                ServerPrepareResult serverPrepareResult = pr;
                return serverPrepareResult;
            }
            this.writer.startPacket(0);
            this.writer.write(22);
            this.writer.write(sql);
            this.writer.flush();
            ComStmtPrepare comStmtPrepare = new ComStmtPrepare(this, sql);
            ServerPrepareResult serverPrepareResult = result = comStmtPrepare.read(this.reader, this.eofDeprecated);
            return serverPrepareResult;
        }
        catch (IOException e) {
            throw this.handleIoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void executeBatchMultiple(boolean mustExecuteOnMaster, Results results, List<String> queries) throws SQLException {
        this.cmdPrologue();
        String firstSql = null;
        int currentIndex = 0;
        int totalQueries = queries.size();
        SQLException exception = null;
        do {
            try {
                firstSql = queries.get(currentIndex++);
                if (totalQueries == 1) {
                    this.writer.startPacket(0);
                    this.writer.write(3);
                    this.writer.write(firstSql);
                    this.writer.flush();
                } else {
                    currentIndex = ComQuery.sendMultiple(this.writer, firstSql, queries, currentIndex);
                }
                this.getResult(results);
            }
            catch (SQLException sqlException) {
                this.logQuery.exceptionWithQuery(firstSql, sqlException);
                if (!this.getOptions().continueBatchOnError) {
                    throw sqlException;
                }
                if (exception == null) {
                    exception = sqlException;
                }
            }
            catch (IOException e) {
                throw this.handleIoException(e);
            }
            this.stopIfInterrupted();
        } while (currentIndex < totalQueries);
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void executeBatchRewrite(boolean mustExecuteOnMaster, Results results, ClientPrepareResult prepareResult, List<ParameterHolder[]> parameterList, boolean rewriteValues) throws SQLException {
        this.cmdPrologue();
        int currentIndex = 0;
        int totalParameterList = parameterList.size();
        try {
            do {
                ParameterHolder[] parameters = parameterList.get(currentIndex++);
                currentIndex = ComQuery.sendRewriteCmd(this.writer, prepareResult.getQueryParts(), parameters, currentIndex, prepareResult.getParamCount(), parameterList, rewriteValues);
                this.getResult(results);
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new SQLException("Interrupted during batch", SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), -1);
            } while (currentIndex < totalParameterList);
        }
        catch (SQLException sqlEx) {
            throw this.logQuery.exceptionWithQuery(sqlEx, prepareResult);
        }
        catch (IOException e) {
            throw this.handleIoException(e);
        }
    }

    @Override
    public ServerPrepareResult prepareAndExecutes(boolean mustExecuteOnMaster, ServerPrepareResult serverPrepareResult, Results results, String sql, final List<ParameterHolder[]> parametersList) throws SQLException {
        this.cmdPrologue();
        return (ServerPrepareResult)new AbstractMultiSend(this, this.writer, results, serverPrepareResult, parametersList, true, sql){

            @Override
            public void sendCmd(PacketOutputStream writer, Results results, List<ParameterHolder[]> parametersList2, List<String> queries, int paramCount, BulkStatus status, PrepareResult prepareResult) throws SQLException, IOException {
                ParameterHolder[] parameters = parametersList2.get(status.sendCmdCounter);
                if (parameters.length < paramCount) {
                    throw new SQLException("Parameter at position " + (paramCount - 1) + " is not set", "07004");
                }
                for (int i = 0; i < paramCount; ++i) {
                    if (!parameters[i].isLongData()) continue;
                    writer.startPacket(0);
                    writer.write(24);
                    writer.writeInt(this.statementId);
                    writer.writeShort((short)i);
                    parameters[i].writeBinary(writer);
                    writer.flush();
                }
                writer.startPacket(0);
                ComStmtExecute.writeCmd(this.statementId, parameters, paramCount, this.parameterTypeHeader, writer, (byte)0);
                writer.flush();
            }

            @Override
            public SQLException handleResultException(SQLException qex, Results results, List<ParameterHolder[]> parametersList2, List<String> queries, int currentCounter, int sendCmdCounter, int paramCount, PrepareResult prepareResult) throws SQLException {
                return AbstractQueryProtocol.this.logQuery.exceptionWithQuery(qex, prepareResult);
            }

            @Override
            public int getParamCount() {
                return this.getPrepareResult() == null ? ((ParameterHolder[])parametersList.get(0)).length : ((ServerPrepareResult)this.getPrepareResult()).getParameters().length;
            }

            @Override
            public int getTotalExecutionNumber() {
                return parametersList.size();
            }
        }.executeBatch();
    }

    @Override
    public ServerPrepareResult prepareAndExecute(boolean mustExecuteOnMaster, ServerPrepareResult serverPrepareResult, Results results, String sql, ParameterHolder[] parameters) throws SQLException {
        this.cmdPrologue();
        int statementId = -1;
        int parameterCount = parameters.length;
        ColumnType[] parameterTypeHeader = new ColumnType[parameters.length];
        if (this.getOptions().cachePrepStmts) {
            String key = this.getDatabase() + "-" + sql;
            serverPrepareResult = (ServerPrepareResult)this.prepareStatementCache().get(key);
            if (serverPrepareResult != null && !serverPrepareResult.incrementShareCounter()) {
                serverPrepareResult = null;
            }
            statementId = serverPrepareResult == null ? -1 : serverPrepareResult.getStatementId();
        }
        try {
            if (serverPrepareResult == null) {
                ComStmtPrepare comStmtPrepare = new ComStmtPrepare(this, sql);
                comStmtPrepare.send(this.writer);
                serverPrepareResult = comStmtPrepare.read(this.reader, this.eofDeprecated);
                statementId = serverPrepareResult.getStatementId();
                parameterCount = serverPrepareResult.getParameters().length;
            }
            if (serverPrepareResult != null && parameters.length < parameterCount) {
                throw new SQLException("Parameter at position " + parameterCount + " is not set", "07004");
            }
            for (int i = 0; i < parameterCount; ++i) {
                if (!parameters[i].isLongData()) continue;
                this.writer.startPacket(0);
                this.writer.write(24);
                this.writer.writeInt(statementId);
                this.writer.writeShort((short)i);
                parameters[i].writeBinary(this.writer);
                this.writer.flush();
            }
            this.writer.startPacket(0);
            ComStmtExecute.writeCmd(statementId, parameters, parameterCount, parameterTypeHeader, this.writer, (byte)0);
            this.writer.flush();
            this.getResult(results);
            return serverPrepareResult;
        }
        catch (IOException e) {
            throw this.handleIoException(e);
        }
    }

    @Override
    public void executePreparedQuery(boolean mustExecuteOnMaster, ServerPrepareResult serverPrepareResult, Results results, ParameterHolder[] parameters) throws SQLException {
        this.cmdPrologue();
        try {
            int parameterCount = serverPrepareResult.getParameters().length;
            for (int i = 0; i < parameterCount; ++i) {
                if (!parameters[i].isLongData()) continue;
                this.writer.startPacket(0);
                this.writer.write(24);
                this.writer.writeInt(serverPrepareResult.getStatementId());
                this.writer.writeShort((short)i);
                parameters[i].writeBinary(this.writer);
                this.writer.flush();
            }
            new ComStmtExecute(serverPrepareResult.getStatementId(), parameters, parameterCount, serverPrepareResult.getParameterTypeHeader(), 0).send(this.writer);
            this.getResult(results);
        }
        catch (SQLException qex) {
            throw this.logQuery.exceptionWithQuery(parameters, qex, serverPrepareResult);
        }
        catch (IOException e) {
            throw this.handleIoException(e);
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.cmdPrologue();
        this.lock.lock();
        try {
            if (this.inTransaction()) {
                this.executeQuery("ROLLBACK");
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean forceReleasePrepareStatement(int statementId) throws SQLException {
        if (this.lock.tryLock()) {
            try {
                this.checkClose();
                try {
                    this.writer.startPacket(0);
                    this.writer.write(25);
                    this.writer.writeInt(statementId & 0xFF);
                    this.writer.flush();
                    boolean bl = true;
                    return bl;
                }
                catch (IOException e) {
                    throw new SQLException("Could not deallocate query: " + e.getMessage(), SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        this.statementIdToRelease = statementId;
        return false;
    }

    @Override
    public void forceReleaseWaitingPrepareStatement() throws SQLException {
        if (this.statementIdToRelease != -1 && this.forceReleasePrepareStatement(this.statementIdToRelease)) {
            this.statementIdToRelease = -1;
        }
    }

    @Override
    public boolean ping() throws SQLException {
        this.cmdPrologue();
        this.lock.lock();
        try {
            this.writer.startPacket(0);
            this.writer.write(14);
            this.writer.flush();
            Buffer buffer = this.reader.getPacket(true);
            boolean bl = buffer.getByteAt(0) == 0;
            return bl;
        }
        catch (IOException e) {
            throw new SQLException("Could not ping: " + e.getMessage(), SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setCatalog(String database) throws SQLException {
        this.cmdPrologue();
        this.lock.lock();
        try {
            SendChangeDbPacket packet = new SendChangeDbPacket(database);
            packet.send(this.writer);
            Buffer buffer = this.reader.getPacket(true);
            if (buffer.getByteAt(0) == -1) {
                ErrorPacket ep = new ErrorPacket(buffer);
                throw new SQLException("Could not select database '" + database + "' : " + ep.getMessage(), ep.getSqlState(), ep.getErrorNumber());
            }
            this.database = database;
        }
        catch (IOException e) {
            throw this.handleIoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void cancelCurrentQuery() throws SQLException, IOException {
        try (MasterProtocol copiedProtocol = new MasterProtocol(this.urlParser, new ReentrantLock());){
            copiedProtocol.setHostAddress(this.getHostAddress());
            copiedProtocol.connect();
            copiedProtocol.executeQuery("KILL QUERY " + this.serverThreadId);
        }
        this.interrupted = true;
    }

    @Override
    public boolean getAutocommit() {
        return (this.serverStatus & 2) != 0;
    }

    @Override
    public boolean inTransaction() {
        return (this.serverStatus & 1) != 0;
    }

    @Override
    public void closeExplicit() {
        this.explicitClosed = true;
        this.close();
    }

    @Override
    public void releasePrepareStatement(ServerPrepareResult serverPrepareResult) throws SQLException {
        serverPrepareResult.decrementShareCounter();
        if (serverPrepareResult.canBeDeallocate()) {
            this.forceReleasePrepareStatement(serverPrepareResult.getStatementId());
        }
    }

    @Override
    public void setInternalMaxRows(long max) {
        if (this.maxRows != max) {
            this.maxRows = max;
        }
    }

    @Override
    public long getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(long max) throws SQLException {
        if (this.maxRows != max) {
            if (max == 0L) {
                this.executeQuery("set @@SQL_SELECT_LIMIT=DEFAULT");
            } else {
                this.executeQuery("set @@SQL_SELECT_LIMIT=" + max);
            }
            this.maxRows = max;
        }
    }

    @Override
    public void setLocalInfileInputStream(InputStream inputStream) {
        this.localInfileInputStream = inputStream;
    }

    @Override
    public int getTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    @Override
    public void setTimeout(int timeout) throws SocketException {
        this.lock.lock();
        try {
            this.getOptions().socketTimeout = timeout;
            this.socket.setSoTimeout(timeout);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.cmdPrologue();
        this.lock.lock();
        try {
            String query = "SET SESSION TRANSACTION ISOLATION LEVEL";
            switch (level) {
                case 1: {
                    query = query + " READ UNCOMMITTED";
                    break;
                }
                case 2: {
                    query = query + " READ COMMITTED";
                    break;
                }
                case 4: {
                    query = query + " REPEATABLE READ";
                    break;
                }
                case 8: {
                    query = query + " SERIALIZABLE";
                    break;
                }
                default: {
                    throw new SQLException("Unsupported transaction isolation level");
                }
            }
            this.executeQuery(query);
            this.transactionIsolationLevel = level;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    private void checkClose() throws SQLException {
        if (!this.connected) {
            throw new SQLException("Connection is close", "08000", 1220);
        }
    }

    @Override
    public void getResult(Results results) throws SQLException {
        this.readPacket(results);
        while (this.hasMoreResults()) {
            this.readPacket(results);
        }
    }

    public void readPacket(Results results) throws SQLException {
        Buffer buffer;
        try {
            buffer = this.reader.getPacket(true);
        }
        catch (IOException e) {
            throw this.handleIoException(e);
        }
        switch (buffer.getByteAt(0)) {
            case 0: {
                this.readOkPacket(buffer, results);
                break;
            }
            case -1: {
                throw this.readErrorPacket(buffer, results);
            }
            case -5: {
                this.readLocalInfilePacket(buffer, results);
                break;
            }
            default: {
                this.readResultSet(buffer, results);
            }
        }
    }

    public void readOkPacket(Buffer buffer, Results results) throws SQLException {
        buffer.skipByte();
        long updateCount = buffer.getLengthEncodedNumeric();
        long insertId = buffer.getLengthEncodedNumeric();
        this.serverStatus = buffer.readShort();
        boolean bl = this.hasWarnings = buffer.readShort() > 0;
        if ((this.serverStatus & 0x4000) != 0) {
            this.handleStateChange(buffer, results);
        }
        results.addStats(updateCount, insertId, this.hasMoreResults());
    }

    private void handleStateChange(Buffer buf, Results results) throws SQLException {
        buf.skipLengthEncodedBytes();
        block10: while (buf.remaining() > 0) {
            Buffer stateInfo = buf.getLengthEncodedBuffer();
            if (stateInfo.remaining() <= 0) continue;
            switch (stateInfo.readByte()) {
                case 0: {
                    Buffer sessionVariableBuf = stateInfo.getLengthEncodedBuffer();
                    String variable = sessionVariableBuf.readStringLengthEncoded(StandardCharsets.UTF_8);
                    String value = sessionVariableBuf.readStringLengthEncoded(StandardCharsets.UTF_8);
                    logger.debug("System variable change : " + variable + "=" + value);
                    switch (variable) {
                        case "auto_increment_increment": {
                            this.autoIncrementIncrement = Integer.parseInt(value);
                            results.setAutoIncrement(this.autoIncrementIncrement);
                        }
                    }
                    continue block10;
                }
                case 1: {
                    Buffer sessionSchemaBuf = stateInfo.getLengthEncodedBuffer();
                    this.database = sessionSchemaBuf.readStringLengthEncoded(StandardCharsets.UTF_8);
                    logger.debug("default database change. is now '" + this.database + "'");
                    continue block10;
                }
            }
            stateInfo.skipLengthEncodedBytes();
        }
    }

    @Override
    public int getAutoIncrementIncrement() {
        if (this.autoIncrementIncrement == 0) {
            try {
                Results results = new Results();
                this.executeQuery(true, results, "select @@auto_increment_increment");
                results.commandEnd();
                SelectResultSet rs = results.getResultSet();
                rs.next();
                this.autoIncrementIncrement = rs.getInt(1);
            }
            catch (Exception e) {
                this.autoIncrementIncrement = 1;
            }
        }
        return this.autoIncrementIncrement;
    }

    public SQLException readErrorPacket(Buffer buffer, Results results) {
        String message;
        String sqlState;
        this.removeHasMoreResults();
        this.hasWarnings = false;
        buffer.skipByte();
        short errorNumber = buffer.readShort();
        if (buffer.readByte() == 35) {
            sqlState = new String(buffer.readRawBytes(5));
            message = buffer.readStringNullEnd(StandardCharsets.UTF_8);
        } else {
            --buffer.position;
            message = new String(buffer.buf, buffer.position, buffer.limit - buffer.position, StandardCharsets.UTF_8);
            sqlState = "HY000";
        }
        results.addStatsError(false);
        this.removeActiveStreamingResult();
        return new SQLException(message, sqlState, errorNumber);
    }

    public void readLocalInfilePacket(Buffer buffer, Results results) throws SQLException {
        int seq = 2;
        buffer.getLengthEncodedNumeric();
        String fileName = buffer.readStringNullEnd(StandardCharsets.UTF_8);
        try {
            InputStream is;
            this.writer.startPacket(seq);
            if (this.localInfileInputStream == null) {
                if (!this.getUrlParser().getOptions().allowLocalInfile) {
                    this.writer.writeEmptyPacket();
                    this.reader.getPacket(true);
                    throw new SQLException("Usage of LOCAL INFILE is disabled. To use it enable it via the connection property allowLocalInfile=true", SqlStates.FEATURE_NOT_SUPPORTED.getSqlState(), -1);
                }
                ServiceLoader<LocalInfileInterceptor> loader = ServiceLoader.load(LocalInfileInterceptor.class);
                for (LocalInfileInterceptor interceptor : loader) {
                    if (interceptor.validate(fileName)) continue;
                    this.writer.writeEmptyPacket();
                    this.reader.getPacket(true);
                    throw new SQLException("LOCAL DATA LOCAL INFILE request to send local file named \"" + fileName + "\" not validated by interceptor \"" + interceptor.getClass().getName() + "\"");
                }
                try {
                    URL url = new URL(fileName);
                    is = url.openStream();
                }
                catch (IOException ioe) {
                    try {
                        is = new FileInputStream(fileName);
                    }
                    catch (FileNotFoundException f) {
                        this.writer.writeEmptyPacket();
                        this.reader.getPacket(true);
                        throw new SQLException("Could not send file : " + f.getMessage(), "22000", -1, f);
                    }
                }
            } else {
                is = this.localInfileInputStream;
                this.localInfileInputStream = null;
            }
            try {
                this.writer.startPacket(seq);
                this.writer.write(is, false, false);
                this.writer.flush();
                this.writer.writeEmptyPacket();
            }
            catch (MaxAllowedPacketException ioe) {
                this.writer.writeEmptyPacket(seq++);
                this.reader.getPacket(true);
                throw this.handleIoException(ioe);
            }
            catch (IOException ioe) {
                throw this.handleIoException(ioe);
            }
            finally {
                is.close();
            }
            this.getResult(results);
        }
        catch (IOException e) {
            throw this.handleIoException(e);
        }
    }

    public void readResultSet(Buffer buffer, Results results) throws SQLException {
        long fieldCount = buffer.getLengthEncodedNumeric();
        try {
            ColumnInformation[] ci = new ColumnInformation[(int)fieldCount];
            int i = 0;
            while ((long)i < fieldCount) {
                ci[i] = new ColumnInformation(this.reader.getPacket(false));
                ++i;
            }
            boolean callableResult = false;
            if (!this.eofDeprecated) {
                Buffer bufferEof = this.reader.getPacket(true);
                if (bufferEof.readByte() != -2) {
                    throw new SQLException("Packets out of order when reading field packets, expected was EOF stream." + (this.options.enablePacketDebug ? this.getTraces() : "Packet contents (hex) = " + Utils.hexdump((int)this.options.maxQuerySizeToLog, 0, bufferEof.position, (byte[][])new byte[][]{bufferEof.buf})));
                }
                bufferEof.skipBytes(2);
                callableResult = (bufferEof.readShort() & 0x1000) != 0;
            }
            SelectResultSet selectResultSet = new SelectResultSet(ci, results, this, this.reader, callableResult, this.eofDeprecated);
            results.addResultSet(selectResultSet, this.hasMoreResults());
        }
        catch (IOException e) {
            throw this.handleIoException(e);
        }
    }

    @Override
    public void prologProxy(ServerPrepareResult serverPrepareResult, long maxRows, boolean hasProxy, MariaDbConnection connection, MariaDbStatement statement) throws SQLException {
        this.prolog(maxRows, hasProxy, connection, statement);
    }

    @Override
    public void prolog(long maxRows, boolean hasProxy, MariaDbConnection connection, MariaDbStatement statement) throws SQLException {
        if (this.explicitClosed) {
            throw new SQLException("execute() is called on closed connection");
        }
        if (!hasProxy && this.shouldReconnectWithoutProxy()) {
            try {
                this.connectWithoutProxy();
            }
            catch (SQLException qe) {
                ExceptionMapper.throwException(qe, connection, statement);
            }
        }
        try {
            this.setMaxRows(maxRows);
        }
        catch (SQLException qe) {
            ExceptionMapper.throwException(qe, connection, statement);
        }
        connection.reenableWarnings();
    }

    @Override
    public ServerPrepareResult addPrepareInCache(String key, ServerPrepareResult serverPrepareResult) {
        return this.serverPrepareStatementCache.put(key, serverPrepareResult);
    }

    private void cmdPrologue() throws SQLException {
        if (this.activeStreamingResult != null) {
            this.activeStreamingResult.loadFully(false, this);
            this.activeStreamingResult = null;
        }
        if (this.activeFutureTask != null) {
            try {
                this.activeFutureTask.get();
            }
            catch (ExecutionException executionException) {
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new SQLException("Interrupted reading remaining batch response ", SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), -1, interruptedException);
            }
            finally {
                this.forceReleaseWaitingPrepareStatement();
            }
            this.activeFutureTask = null;
        }
        if (!this.connected) {
            throw new SQLException("Connection is close", "08000", 1220);
        }
        this.interrupted = false;
    }

    @Override
    public void resetStateAfterFailover(long maxRows, int transactionIsolationLevel, String database, boolean autocommit) throws SQLException {
        this.setMaxRows(maxRows);
        if (transactionIsolationLevel != 0) {
            this.setTransactionIsolation(transactionIsolationLevel);
        }
        if (database != null && !"".equals(database) && !this.getDatabase().equals(database)) {
            this.setCatalog(database);
        }
        if (this.getAutocommit() != autocommit) {
            this.executeQuery("set autocommit=" + (autocommit ? "1" : "0"));
        }
    }

    @Override
    public SQLException handleIoException(IOException initialException) {
        boolean mustReconnect;
        boolean driverPreventError = false;
        if (MaxAllowedPacketException.class.isInstance(initialException)) {
            mustReconnect = ((MaxAllowedPacketException)initialException).isMustReconnect();
            driverPreventError = !mustReconnect;
        } else {
            boolean bl = mustReconnect = !this.writer.isAllowedCmdLength();
        }
        if (mustReconnect) {
            try {
                this.connect();
            }
            catch (SQLException queryException) {
                return new SQLNonTransientConnectionException("Could not send query: " + initialException.getMessage() + "\nError during reconnection" + this.getTraces(), SqlStates.CONNECTION_EXCEPTION.getSqlState(), initialException);
            }
            try {
                this.resetStateAfterFailover(this.getMaxRows(), this.getTransactionIsolationLevel(), this.getDatabase(), this.getAutocommit());
            }
            catch (SQLException queryException) {
                return new SQLException("reconnection succeed, but resetting previous state failed", SqlStates.UNDEFINED_SQLSTATE.getSqlState() + this.getTraces(), initialException);
            }
            return new SQLException("Could not send query: query size is >= to max_allowed_packet (" + this.writer.getMaxAllowedPacket() + ")" + this.getTraces(), SqlStates.UNDEFINED_SQLSTATE.getSqlState(), initialException);
        }
        return new SQLException("Could not send query: " + initialException.getMessage() + this.getTraces(), driverPreventError ? SqlStates.UNDEFINED_SQLSTATE.getSqlState() : SqlStates.CONNECTION_EXCEPTION.getSqlState(), initialException);
    }

    @Override
    public void setActiveFutureTask(FutureTask activeFutureTask) {
        this.activeFutureTask = activeFutureTask;
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted;
    }

    @Override
    public void stopIfInterrupted() throws SQLTimeoutException {
        if (this.isInterrupted()) {
            throw new SQLTimeoutException("Timeout during batch execution");
        }
    }
}

