/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import me.lucko.helper.sql.external.mariadb.jdbc.HostAddress;
import me.lucko.helper.sql.external.mariadb.jdbc.MariaDbConnection;
import me.lucko.helper.sql.external.mariadb.jdbc.UrlParser;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.Buffer;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.ErrorPacket;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.OkPacket;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.ReadInitialHandShakePacket;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.dao.Results;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.resultset.SelectResultSet;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.InterfaceAuthSwitchSendResponsePacket;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.SendClosePacket;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.SendHandshakeResponsePacket;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.SendOldPasswordAuthPacket;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.SendSslConnectionRequestPacket;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.failover.FailoverProxy;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.LruTraceCache;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.input.DecompressPacketInputStream;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.input.PacketInputStream;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.input.StandardPacketInputStream;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.output.CompressPacketOutputStream;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.output.PacketOutputStream;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.output.StandardPacketOutputStream;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.logging.Logger;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.logging.LoggerFactory;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol.Protocol;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol.authentication.AuthenticationProviderHolder;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol.tls.MariaDbX509KeyManager;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol.tls.MariaDbX509TrustManager;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.Options;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.ServerPrepareStatementCache;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.SqlStates;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.Utils;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.constant.HaMode;

public abstract class AbstractConnectProtocol
implements Protocol {
    public static final byte[] SESSION_QUERY = "SELECT @@max_allowed_packet,@@system_time_zone,@@time_zone,@@sql_mode,@@auto_increment_increment".getBytes(StandardCharsets.UTF_8);
    public static final byte[] IS_MASTER_QUERY = "show global variables like 'innodb_read_only'".getBytes(StandardCharsets.UTF_8);
    private static Logger logger = LoggerFactory.getLogger(AbstractConnectProtocol.class);
    protected final ReentrantLock lock;
    protected final UrlParser urlParser;
    protected final Options options;
    private final String username;
    private final String password;
    public boolean hasWarnings = false;
    public Results activeStreamingResult = null;
    public int dataTypeMappingFlags;
    public short serverStatus;
    protected int autoIncrementIncrement;
    protected Socket socket;
    protected PacketOutputStream writer;
    protected boolean readOnly = false;
    protected PacketInputStream reader;
    protected HostAddress currentHost;
    protected FailoverProxy proxy;
    protected volatile boolean connected = false;
    protected boolean explicitClosed = false;
    protected String database;
    protected long serverThreadId;
    protected ServerPrepareStatementCache serverPrepareStatementCache;
    protected boolean eofDeprecated = false;
    protected long serverCapabilities;
    private boolean hostFailed;
    private String serverVersion;
    private boolean serverMariaDb;
    private int majorVersion;
    private int minorVersion;
    private int patchVersion;
    private Map<String, String> serverData;
    private TimeZone timeZone;
    private LruTraceCache traceCache = new LruTraceCache();

    public AbstractConnectProtocol(UrlParser urlParser, ReentrantLock lock) {
        urlParser.auroraPipelineQuirks();
        this.lock = lock;
        this.urlParser = urlParser;
        this.options = this.urlParser.getOptions();
        this.database = urlParser.getDatabase() == null ? "" : urlParser.getDatabase();
        this.username = urlParser.getUsername() == null ? "" : urlParser.getUsername();
        String string = this.password = urlParser.getPassword() == null ? "" : urlParser.getPassword();
        if (this.options.cachePrepStmts) {
            this.serverPrepareStatementCache = ServerPrepareStatementCache.newInstance(this.options.prepStmtCacheSize, this);
        }
        this.setDataTypeMappingFlags();
    }

    protected static void close(PacketInputStream packetInputStream, PacketOutputStream packetOutputStream, Socket socket) throws SQLException {
        SendClosePacket closePacket = new SendClosePacket();
        try {
            try {
                closePacket.send(packetOutputStream);
                socket.shutdownOutput();
                socket.setSoTimeout(3);
                InputStream is = socket.getInputStream();
                while (is.read() != -1) {
                }
            }
            catch (Throwable is) {
                // empty catch block
            }
            packetOutputStream.close();
            packetInputStream.close();
        }
        catch (IOException e) {
            throw new SQLException("Could not close connection: " + e.getMessage(), SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void close() {
        if (this.lock != null) {
            this.lock.lock();
        }
        this.connected = false;
        try {
            this.skip();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.options.cachePrepStmts) {
                this.serverPrepareStatementCache.clear();
            }
            AbstractConnectProtocol.close(this.reader, this.writer, this.socket);
        }
        catch (Exception exception) {
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
        if (this.options.enablePacketDebug) {
            this.traceCache.clearMemory();
        }
    }

    @Override
    public void skip() throws SQLException {
        if (this.activeStreamingResult != null) {
            this.activeStreamingResult.loadFully(true, this);
            this.activeStreamingResult = null;
        }
    }

    @Override
    public void setServerStatus(short serverStatus) {
        this.serverStatus = serverStatus;
    }

    @Override
    public void removeHasMoreResults() {
        if (this.hasMoreResults()) {
            this.serverStatus = (short)(this.serverStatus ^ 8);
        }
    }

    private SSLSocketFactory getSslSocketFactory() throws SQLException {
        if (!this.options.trustServerCertificate && this.options.serverSslCert == null && this.options.trustStore == null && this.options.keyStore == null) {
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        TrustManager[] trustManager = null;
        KeyManager[] keyManager = null;
        if (this.options.trustServerCertificate || this.options.serverSslCert != null || this.options.trustStore != null) {
            trustManager = new X509TrustManager[]{new MariaDbX509TrustManager(this.options)};
        }
        if (this.options.keyStore != null) {
            keyManager = new KeyManager[]{this.loadClientCerts(this.options.keyStore, this.options.keyStorePassword, this.options.keyPassword)};
        } else {
            String keyStore = System.getProperty("javax.net.ssl.keyStore");
            String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
            if (keyStore != null) {
                try {
                    keyManager = new KeyManager[]{this.loadClientCerts(keyStore, keyStorePassword, keyStorePassword)};
                }
                catch (SQLException queryException) {
                    keyManager = null;
                    logger.error("Error loading keymanager from system properties", queryException);
                }
            }
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManager, trustManager, null);
            return sslContext.getSocketFactory();
        }
        catch (KeyManagementException keyManagementEx) {
            throw new SQLException("Could not initialize SSL context", SqlStates.CONNECTION_EXCEPTION.getSqlState(), keyManagementEx);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmEx) {
            throw new SQLException("SSLContext TLS Algorithm not unknown", SqlStates.CONNECTION_EXCEPTION.getSqlState(), noSuchAlgorithmEx);
        }
    }

    private KeyManager loadClientCerts(String keyStoreUrl, String keyStorePassword, String keyPassword) throws SQLException {
        InputStream inStream = null;
        try {
            char[] keyStorePasswordChars = keyStorePassword == null ? null : keyStorePassword.toCharArray();
            try {
                inStream = new URL(keyStoreUrl).openStream();
            }
            catch (IOException ioexception) {
                inStream = new FileInputStream(keyStoreUrl);
            }
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(inStream, keyStorePasswordChars);
            char[] keyStoreChars = keyPassword == null ? keyStorePasswordChars : keyPassword.toCharArray();
            MariaDbX509KeyManager mariaDbX509KeyManager = new MariaDbX509KeyManager(ks, keyStoreChars);
            return mariaDbX509KeyManager;
        }
        catch (GeneralSecurityException generalSecurityEx) {
            throw new SQLException("Failed to create keyStore instance", SqlStates.CONNECTION_EXCEPTION.getSqlState(), generalSecurityEx);
        }
        catch (FileNotFoundException fileNotFoundEx) {
            throw new SQLException("Failed to find keyStore file. Option keyStore=" + keyStoreUrl, SqlStates.CONNECTION_EXCEPTION.getSqlState(), fileNotFoundEx);
        }
        catch (IOException ioEx) {
            throw new SQLException("Failed to read keyStore file. Option keyStore=" + keyStoreUrl, SqlStates.CONNECTION_EXCEPTION.getSqlState(), ioEx);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void initializeSocketOption() {
        try {
            if (!this.options.tcpNoDelay) {
                this.socket.setTcpNoDelay(this.options.tcpNoDelay);
            } else {
                this.socket.setTcpNoDelay(true);
            }
            if (this.options.tcpKeepAlive) {
                this.socket.setKeepAlive(true);
            }
            if (this.options.tcpRcvBuf != null) {
                this.socket.setReceiveBufferSize(this.options.tcpRcvBuf);
            }
            if (this.options.tcpSndBuf != null) {
                this.socket.setSendBufferSize(this.options.tcpSndBuf);
            }
            if (this.options.tcpAbortiveClose) {
                this.socket.setSoLinger(true, 0);
            }
        }
        catch (Exception e) {
            logger.debug("Failed to set socket option", e);
        }
    }

    @Override
    public void connect() throws SQLException {
        if (!this.isClosed()) {
            this.close();
        }
        try {
            this.connect(this.currentHost != null ? this.currentHost.host : null, this.currentHost != null ? this.currentHost.port : 3306);
            return;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (IOException e) {
            throw new SQLException("Could not connect to " + this.currentHost + ". " + e.getMessage() + this.getTraces(), SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    private void connect(String host, int port) throws SQLException, IOException {
        try {
            this.socket = Utils.createSocket(this.urlParser, host);
            this.initializeSocketOption();
            if (this.options.localSocketAddress != null) {
                InetSocketAddress localAddress = new InetSocketAddress(this.options.localSocketAddress, 0);
                this.socket.bind(localAddress);
            }
            if (!this.socket.isConnected()) {
                InetSocketAddress sockAddr;
                InetSocketAddress inetSocketAddress = sockAddr = this.urlParser.getOptions().pipe == null ? new InetSocketAddress(host, port) : null;
                if (this.options.connectTimeout != null) {
                    this.socket.connect(sockAddr, this.options.connectTimeout);
                } else {
                    this.socket.connect(sockAddr);
                }
            }
            this.handleConnectionPhases();
            this.connected = true;
            this.serverData = new TreeMap<String, String>();
            if (this.options.useCompression) {
                this.writer = new CompressPacketOutputStream(this.writer.getOutputStream(), this.options.maxQuerySizeToLog);
                this.reader = new DecompressPacketInputStream(((StandardPacketInputStream)this.reader).getBufferedInputStream(), this.options.maxQuerySizeToLog);
                if (this.options.enablePacketDebug) {
                    this.writer.setTraceCache(this.traceCache);
                    this.reader.setTraceCache(this.traceCache);
                }
            }
            if (this.options.usePipelineAuth.booleanValue() && !this.options.createDatabaseIfNotExist) {
                try {
                    this.sendPipelineAdditionalData();
                    this.readPipelineAdditionalData();
                }
                catch (SQLException sqle) {
                    this.additionalData();
                }
            } else {
                this.additionalData();
            }
            this.writer.setMaxAllowedPacket(Integer.parseInt(this.serverData.get("max_allowed_packet")));
            this.autoIncrementIncrement = Integer.parseInt(this.serverData.get("auto_increment_increment"));
            this.loadCalendar();
            if (this.options.socketTimeout != null) {
                this.socket.setSoTimeout(this.options.socketTimeout);
            }
            this.reader.setServerThreadId(this.serverThreadId, this.isMasterConnection());
            this.writer.setServerThreadId(this.serverThreadId, this.isMasterConnection());
            this.serverData = null;
            this.activeStreamingResult = null;
            this.hostFailed = false;
        }
        catch (IOException ioException) {
            this.ensureClosingSocketOnException();
            throw ioException;
        }
        catch (SQLException sqlException) {
            this.ensureClosingSocketOnException();
            throw sqlException;
        }
    }

    private void sendPipelineAdditionalData() throws IOException, SQLException {
        this.sendSessionInfos();
        this.sendRequestSessionVariables();
        this.sendPipelineCheckMaster();
    }

    private void sendSessionInfos() throws IOException {
        StringBuilder sessionOption = new StringBuilder("autocommit=1");
        if ((this.serverCapabilities & 0x800000L) != 0L) {
            sessionOption.append(", session_track_schema=1");
            if (this.options.rewriteBatchedStatements) {
                sessionOption.append(", session_track_system_variables='auto_increment_increment' ");
            }
        }
        if (this.options.jdbcCompliantTruncation) {
            sessionOption.append(", sql_mode = concat(@@sql_mode,',STRICT_TRANS_TABLES')");
        }
        if (this.options.sessionVariables != null && !this.options.sessionVariables.isEmpty()) {
            sessionOption.append("," + Utils.parseSessionVariables(this.options.sessionVariables));
        }
        this.writer.startPacket(0);
        this.writer.write(3);
        this.writer.write("set " + sessionOption.toString());
        this.writer.flush();
    }

    private void sendRequestSessionVariables() throws IOException {
        this.writer.startPacket(0);
        this.writer.write(3);
        this.writer.write(SESSION_QUERY);
        this.writer.flush();
    }

    private void readRequestSessionVariables() throws IOException, SQLException {
        Results results = new Results();
        this.getResult(results);
        results.commandEnd();
        SelectResultSet resultSet = results.getResultSet();
        if (resultSet == null) {
            throw new SQLException("Error reading SessionVariables results. Socket is connected ? " + this.socket.isConnected());
        }
        resultSet.next();
        this.serverData.put("max_allowed_packet", resultSet.getString(1));
        this.serverData.put("system_time_zone", resultSet.getString(2));
        this.serverData.put("time_zone", resultSet.getString(3));
        this.serverData.put("sql_mode", resultSet.getString(4));
        this.serverData.put("auto_increment_increment", resultSet.getString(5));
    }

    private void sendCreateDatabaseIfNotExist(String quotedDb) throws IOException {
        this.writer.startPacket(0);
        this.writer.write(3);
        this.writer.write("CREATE DATABASE IF NOT EXISTS " + quotedDb);
        this.writer.flush();
    }

    private void sendUseDatabaseIfNotExist(String quotedDb) throws IOException {
        this.writer.startPacket(0);
        this.writer.write(3);
        this.writer.write("USE " + quotedDb);
        this.writer.flush();
    }

    private void readPipelineAdditionalData() throws IOException, SQLException {
        boolean sessionDataRead;
        SQLException resultingException;
        block9: {
            resultingException = null;
            try {
                this.getResult(new Results());
            }
            catch (SQLException sqlException) {
                resultingException = sqlException;
            }
            try {
                this.readRequestSessionVariables();
                sessionDataRead = true;
            }
            catch (SQLException sqlException) {
                if (resultingException == null) {
                    resultingException = new SQLException("could not load system variables", SqlStates.CONNECTION_EXCEPTION.getSqlState(), sqlException);
                }
                sessionDataRead = false;
            }
            try {
                this.readPipelineCheckMaster();
            }
            catch (SQLException sqlException) {
                if (resultingException != null) break block9;
                resultingException = new SQLException("could not identified if server is master", SqlStates.CONNECTION_EXCEPTION.getSqlState(), sqlException);
            }
        }
        if (resultingException != null) {
            throw resultingException;
        }
        this.connected = true;
        if (!sessionDataRead) {
            this.requestSessionDataWithShow();
        }
    }

    private void requestSessionDataWithShow() throws IOException, SQLException {
        try {
            Results results = new Results();
            this.executeQuery(true, results, "SHOW VARIABLES WHERE Variable_name in ('max_allowed_packet','system_time_zone','time_zone','sql_mode','auto_increment_increment')");
            results.commandEnd();
            SelectResultSet resultSet = results.getResultSet();
            while (resultSet.next()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("server data " + resultSet.getString(1) + " : " + resultSet.getString(2));
                }
                this.serverData.put(resultSet.getString(1), resultSet.getString(2));
            }
        }
        catch (SQLException sqlee) {
            throw new SQLException("could not load system variables", SqlStates.CONNECTION_EXCEPTION.getSqlState(), sqlee);
        }
    }

    private void additionalData() throws IOException, SQLException {
        this.sendSessionInfos();
        this.getResult(new Results());
        try {
            this.sendRequestSessionVariables();
            this.readRequestSessionVariables();
        }
        catch (SQLException sqlException) {
            this.requestSessionDataWithShow();
        }
        this.sendPipelineCheckMaster();
        this.readPipelineCheckMaster();
        if (this.options.createDatabaseIfNotExist) {
            String quotedDb = MariaDbConnection.quoteIdentifier(this.database);
            this.sendCreateDatabaseIfNotExist(quotedDb);
            this.getResult(new Results());
            this.sendUseDatabaseIfNotExist(quotedDb);
            this.getResult(new Results());
        }
    }

    private void ensureClosingSocketOnException() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isClosed() {
        return !this.connected;
    }

    private void handleConnectionPhases() throws SQLException {
        try {
            this.reader = new StandardPacketInputStream(this.socket.getInputStream(), this.options.maxQuerySizeToLog);
            this.writer = new StandardPacketOutputStream(this.socket.getOutputStream(), this.options.maxQuerySizeToLog);
            if (this.options.enablePacketDebug) {
                this.writer.setTraceCache(this.traceCache);
                this.reader.setTraceCache(this.traceCache);
            }
            ReadInitialHandShakePacket greetingPacket = new ReadInitialHandShakePacket(this.reader);
            this.serverThreadId = greetingPacket.getServerThreadId();
            this.reader.setServerThreadId(this.serverThreadId, null);
            this.writer.setServerThreadId(this.serverThreadId, null);
            this.serverVersion = greetingPacket.getServerVersion();
            this.serverMariaDb = greetingPacket.isServerMariaDb();
            this.serverCapabilities = greetingPacket.getServerCapabilities();
            byte exchangeCharset = this.decideLanguage(greetingPacket.getServerLanguage());
            this.parseVersion();
            long clientCapabilities = this.initializeClientCapabilities(this.serverCapabilities);
            byte packetSeq = 1;
            if (this.options.useSsl && (greetingPacket.getServerCapabilities() & 0x800L) != 0L) {
                SendSslConnectionRequestPacket amcap = new SendSslConnectionRequestPacket(clientCapabilities |= 0x800L, exchangeCharset);
                amcap.send(this.writer);
                SSLSocketFactory sslSocketFactory = this.getSslSocketFactory();
                SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(this.socket, this.socket.getInetAddress().getHostAddress(), this.socket.getPort(), true);
                this.enabledSslProtocolSuites(sslSocket);
                this.enabledSslCipherSuites(sslSocket);
                sslSocket.setUseClientMode(true);
                sslSocket.startHandshake();
                this.socket = sslSocket;
                this.writer = new StandardPacketOutputStream(this.socket.getOutputStream(), this.options.maxQuerySizeToLog);
                this.reader = new StandardPacketInputStream(this.socket.getInputStream(), this.options.maxQuerySizeToLog);
                if (this.options.enablePacketDebug) {
                    this.writer.setTraceCache(this.traceCache);
                    this.reader.setTraceCache(this.traceCache);
                }
                packetSeq = (byte)(packetSeq + 1);
            } else if (this.options.useSsl) {
                throw new SQLException("Trying to connect with ssl, but ssl not enabled in the server");
            }
            this.authentication(exchangeCharset, clientCapabilities, greetingPacket.getSeed(), packetSeq, greetingPacket.getPluginName());
        }
        catch (IOException e) {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new SQLException("Could not connect to " + this.currentHost.host + ":" + this.currentHost.port + ": " + e.getMessage(), SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    private void authentication(byte exchangeCharset, long clientCapabilities, byte[] seed, byte packetSeq, String plugin) throws SQLException, IOException {
        SendHandshakeResponsePacket.send(this.writer, this.username, this.password, this.database, clientCapabilities, this.serverCapabilities, exchangeCharset, seed, packetSeq, plugin, this.options);
        Buffer buffer = this.reader.getPacket(false);
        if ((buffer.getByteAt(0) & 0xFF) == 254) {
            InterfaceAuthSwitchSendResponsePacket interfaceSendPacket;
            this.writer.permitTrace(false);
            if ((this.serverCapabilities & 0x80000L) != 0L) {
                byte[] authData;
                buffer.readByte();
                if (buffer.remaining() > 0) {
                    plugin = buffer.readStringNullEnd(Charset.forName("ASCII"));
                    authData = buffer.readRawBytes(buffer.remaining());
                } else {
                    plugin = "mysql_old_password";
                    authData = Utils.copyWithLength(seed, 8);
                }
                interfaceSendPacket = AuthenticationProviderHolder.getAuthenticationProvider().processAuthPlugin(this.reader, plugin, this.password, authData, this.reader.getLastPacketSeq() + 1, this.options.passwordCharacterEncoding);
            } else {
                interfaceSendPacket = new SendOldPasswordAuthPacket(this.password, Utils.copyWithLength(seed, 8), this.reader.getLastPacketSeq() + 1, this.options.passwordCharacterEncoding);
            }
            interfaceSendPacket.send(this.writer);
            interfaceSendPacket.handleResultPacket(this.reader);
        } else {
            if (buffer.getByteAt(0) == -1) {
                ErrorPacket errorPacket = new ErrorPacket(buffer);
                if (this.password != null && !this.password.isEmpty() && errorPacket.getErrorNumber() == 1045 && "28000".equals(errorPacket.getSqlState())) {
                    throw new SQLException("Could not connect: " + errorPacket.getMessage() + "\nCurrent charset is " + Charset.defaultCharset().displayName() + ". If password has been set using other charset, consider using option 'passwordCharacterEncoding'", errorPacket.getSqlState(), errorPacket.getErrorNumber());
                }
                throw new SQLException("Could not connect: " + errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorNumber());
            }
            this.serverStatus = new OkPacket(buffer).getServerStatus();
        }
        this.writer.permitTrace(true);
    }

    private long initializeClientCapabilities(long serverCapabilities) {
        long capabilities = 12493698L;
        if (this.options.allowMultiQueries || this.options.rewriteBatchedStatements) {
            capabilities |= 0x10000L;
        }
        if ((serverCapabilities & 0x1000000L) != 0L) {
            capabilities |= 0x1000000L;
            this.eofDeprecated = true;
        }
        if (this.options.useCompression) {
            if ((serverCapabilities & 0x20L) == 0L) {
                this.options.useCompression = false;
            } else {
                capabilities |= 0x20L;
            }
        }
        if (this.options.interactiveClient) {
            capabilities |= 0x400L;
        }
        if (this.database != null && !this.options.createDatabaseIfNotExist) {
            capabilities |= 8L;
        }
        return capabilities;
    }

    private void loadCalendar() throws SQLException {
        if (this.options.useLegacyDatetimeCode) {
            this.timeZone = Calendar.getInstance().getTimeZone();
        } else {
            String tz = null;
            if (this.options.serverTimezone != null) {
                tz = this.options.serverTimezone;
            }
            if (tz == null && "SYSTEM".equals(tz = this.serverData.get("time_zone"))) {
                tz = this.serverData.get("system_time_zone");
            }
            if (tz != null && tz.length() >= 2 && (tz.startsWith("+") || tz.startsWith("-")) && Character.isDigit(tz.charAt(1))) {
                tz = "GMT" + tz;
            }
            try {
                this.timeZone = Utils.getTimeZone(tz);
            }
            catch (SQLException e) {
                if (this.options.serverTimezone != null) {
                    throw new SQLException("The server time_zone '" + tz + "' defined in the 'serverTimezone' parameter cannot be parsed by java TimeZone implementation. See java.util.TimeZone#getAvailableIDs() for available TimeZone, depending on your JRE implementation.", "01S00");
                }
                throw new SQLException("The server time_zone '" + tz + "' cannot be parsed. The server time zone must defined in the jdbc url string with the 'serverTimezone' parameter (or server time zone must be defined explicitly with sessionVariables=time_zone='Canada/Atlantic' for example).  See java.util.TimeZone#getAvailableIDs() for available TimeZone, depending on your JRE implementation.", "01S00");
            }
        }
    }

    public String getServerData(String code) {
        return this.serverData.get(code);
    }

    @Override
    public boolean checkIfMaster() throws SQLException {
        return this.isMasterConnection();
    }

    private boolean isServerLanguageUtf8mb4(byte serverLanguage) {
        Byte[] utf8mb4Languages = new Byte[]{(byte)45, (byte)46, (byte)-32, (byte)-31, (byte)-30, (byte)-29, (byte)-28, (byte)-27, (byte)-26, (byte)-25, (byte)-24, (byte)-23, (byte)-22, (byte)-21, (byte)-20, (byte)-19, (byte)-18, (byte)-17, (byte)-16, (byte)-15, (byte)-14, (byte)-13, (byte)-11, (byte)-10, (byte)-9};
        return Arrays.asList(utf8mb4Languages).contains(serverLanguage);
    }

    private byte decideLanguage(byte serverLanguage) {
        byte result = this.isServerLanguageUtf8mb4(serverLanguage) ? serverLanguage : (byte)33;
        return result;
    }

    @Override
    public void readEofPacket() throws SQLException, IOException {
        Buffer buffer = this.reader.getPacket(true);
        switch (buffer.getByteAt(0)) {
            case -2: {
                buffer.skipByte();
                this.hasWarnings = buffer.readShort() > 0;
                this.serverStatus = buffer.readShort();
                break;
            }
            case -1: {
                ErrorPacket ep = new ErrorPacket(buffer);
                throw new SQLException("Could not connect: " + ep.getMessage(), ep.getSqlState(), ep.getErrorNumber());
            }
            default: {
                throw new SQLException("Unexpected packet type " + buffer.getByteAt(0) + " instead of EOF");
            }
        }
    }

    @Override
    public void skipEofPacket() throws SQLException, IOException {
        Buffer buffer = this.reader.getPacket(true);
        switch (buffer.getByteAt(0)) {
            case -2: {
                break;
            }
            case -1: {
                ErrorPacket ep = new ErrorPacket(buffer);
                throw new SQLException("Could not connect: " + ep.getMessage(), ep.getSqlState(), ep.getErrorNumber());
            }
            default: {
                throw new SQLException("Unexpected packet type " + buffer.getByteAt(0) + " instead of EOF");
            }
        }
    }

    @Override
    public void setHostFailedWithoutProxy() {
        this.hostFailed = true;
        this.close();
    }

    @Override
    public UrlParser getUrlParser() {
        return this.urlParser;
    }

    @Override
    public boolean isMasterConnection() {
        return this.currentHost == null ? true : "master".equals(this.currentHost.type);
    }

    public void sendPipelineCheckMaster() throws IOException {
        if (this.urlParser.getHaMode() == HaMode.AURORA) {
            this.writer.startPacket(0);
            this.writer.write(3);
            this.writer.write(IS_MASTER_QUERY);
            this.writer.flush();
        }
    }

    public void readPipelineCheckMaster() throws IOException, SQLException {
    }

    @Override
    public boolean mustBeMasterConnection() {
        return true;
    }

    @Override
    public boolean noBackslashEscapes() {
        return (this.serverStatus & 0x200) != 0;
    }

    @Override
    public void connectWithoutProxy() throws SQLException {
        LinkedList<HostAddress> hosts;
        List<HostAddress> addrs;
        Random rand;
        block9: {
            if (!this.isClosed()) {
                this.close();
            }
            rand = new Random();
            addrs = this.urlParser.getHostAddresses();
            hosts = new LinkedList<HostAddress>(addrs);
            if (hosts.isEmpty() && this.options.pipe != null) {
                try {
                    this.connect(null, 0);
                    return;
                }
                catch (SQLException sqle) {
                    throw sqle;
                }
                catch (IOException e) {
                    if (!hosts.isEmpty()) break block9;
                    throw new SQLException("Could not connect to named pipe '" + this.options.pipe + "' : " + e.getMessage() + this.getTraces(), SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
                }
            }
        }
        while (!hosts.isEmpty()) {
            this.currentHost = this.urlParser.getHaMode().equals((Object)HaMode.LOADBALANCE) ? (HostAddress)hosts.get(rand.nextInt(hosts.size())) : (HostAddress)hosts.get(0);
            hosts.remove(this.currentHost);
            try {
                this.connect(this.currentHost.host, this.currentHost.port);
                return;
            }
            catch (SQLException sqle) {
                throw sqle;
            }
            catch (IOException e) {
                if (!hosts.isEmpty()) continue;
                throw new SQLException("Could not connect to " + HostAddress.toString(addrs) + " : " + e.getMessage() + this.getTraces(), SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
            }
        }
    }

    @Override
    public boolean shouldReconnectWithoutProxy() {
        return (this.serverStatus & 1) == 0 && this.hostFailed && this.urlParser.getOptions().autoReconnect;
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public boolean getReadonly() {
        return this.readOnly;
    }

    @Override
    public void setReadonly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public HostAddress getHostAddress() {
        return this.currentHost;
    }

    @Override
    public void setHostAddress(HostAddress host) {
        this.currentHost = host;
        this.readOnly = "slave".equals(this.currentHost.type);
    }

    @Override
    public String getHost() {
        return this.currentHost == null ? null : this.currentHost.host;
    }

    @Override
    public FailoverProxy getProxy() {
        return this.proxy;
    }

    @Override
    public void setProxy(FailoverProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public int getPort() {
        return this.currentHost == null ? 3306 : this.currentHost.port;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    private void parseVersion() {
        String[] versionArray = this.serverVersion.split("[^0-9]");
        if (versionArray.length > 0) {
            this.majorVersion = Integer.parseInt(versionArray[0]);
        }
        if (versionArray.length > 1) {
            this.minorVersion = Integer.parseInt(versionArray[1]);
        }
        if (versionArray.length > 2) {
            this.patchVersion = Integer.parseInt(versionArray[2]);
        }
    }

    @Override
    public int getMajorServerVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorServerVersion() {
        return this.minorVersion;
    }

    protected void enabledSslProtocolSuites(SSLSocket sslSocket) throws SQLException {
        if (this.options.enabledSslProtocolSuites == null) {
            sslSocket.setEnabledProtocols(new String[]{"TLSv1", "TLSv1.1"});
        } else {
            String[] protocols;
            List<String> possibleProtocols = Arrays.asList(sslSocket.getSupportedProtocols());
            for (String protocol : protocols = this.options.enabledSslProtocolSuites.split("[,;\\s]+")) {
                if (possibleProtocols.contains(protocol)) continue;
                throw new SQLException("Unsupported SSL protocol '" + protocol + "'. Supported protocols : " + possibleProtocols.toString().replace("[", "").replace("]", ""));
            }
            sslSocket.setEnabledProtocols(protocols);
        }
    }

    protected void enabledSslCipherSuites(SSLSocket sslSocket) throws SQLException {
        if (this.options.enabledSslCipherSuites != null) {
            String[] ciphers;
            List<String> possibleCiphers = Arrays.asList(sslSocket.getSupportedCipherSuites());
            for (String cipher : ciphers = this.options.enabledSslCipherSuites.split("[,;\\s]+")) {
                if (possibleCiphers.contains(cipher)) continue;
                throw new SQLException("Unsupported SSL cipher '" + cipher + "'. Supported ciphers : " + possibleCiphers.toString().replace("[", "").replace("]", ""));
            }
            sslSocket.setEnabledCipherSuites(ciphers);
        }
    }

    @Override
    public boolean versionGreaterOrEqual(int major, int minor, int patch) {
        if (this.majorVersion > major) {
            return true;
        }
        if (this.majorVersion < major) {
            return false;
        }
        if (this.minorVersion > minor) {
            return true;
        }
        if (this.minorVersion < minor) {
            return false;
        }
        if (this.patchVersion > patch) {
            return true;
        }
        return this.patchVersion >= patch;
    }

    @Override
    public boolean getPinGlobalTxToPhysicalConnection() {
        return this.options.pinGlobalTxToPhysicalConnection;
    }

    @Override
    public boolean hasWarnings() {
        this.lock.lock();
        try {
            boolean bl = this.hasWarnings;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isConnected() {
        this.lock.lock();
        try {
            boolean bl = this.connected;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void setDataTypeMappingFlags() {
        this.dataTypeMappingFlags = 0;
        if (this.options.tinyInt1isBit) {
            this.dataTypeMappingFlags |= 1;
        }
        if (this.options.yearIsDateType) {
            this.dataTypeMappingFlags |= 2;
        }
    }

    @Override
    public long getServerThreadId() {
        return this.serverThreadId;
    }

    @Override
    public int getDataTypeMappingFlags() {
        return this.dataTypeMappingFlags;
    }

    @Override
    public boolean isExplicitClosed() {
        return this.explicitClosed;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public void setHasWarnings(boolean hasWarnings) {
        this.hasWarnings = hasWarnings;
    }

    @Override
    public Results getActiveStreamingResult() {
        return this.activeStreamingResult;
    }

    @Override
    public void setActiveStreamingResult(Results activeStreamingResult) {
        this.activeStreamingResult = activeStreamingResult;
    }

    @Override
    public void removeActiveStreamingResult() {
        if (this.activeStreamingResult != null) {
            this.activeStreamingResult.removeFetchSize();
            this.activeStreamingResult = null;
        }
    }

    @Override
    public ReentrantLock getLock() {
        return this.lock;
    }

    @Override
    public boolean hasMoreResults() {
        return (this.serverStatus & 8) != 0;
    }

    @Override
    public ServerPrepareStatementCache prepareStatementCache() {
        return this.serverPrepareStatementCache;
    }

    @Override
    public abstract void executeQuery(String var1) throws SQLException;

    @Override
    public void changeSocketTcpNoDelay(boolean setTcpNoDelay) {
        try {
            this.socket.setTcpNoDelay(setTcpNoDelay);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public void changeSocketSoTimeout(int setSoTimeout) throws SocketException {
        this.socket.setSoTimeout(setSoTimeout);
    }

    @Override
    public boolean isServerMariaDb() {
        return this.serverMariaDb;
    }

    @Override
    public PacketInputStream getReader() {
        return this.reader;
    }

    @Override
    public PacketOutputStream getWriter() {
        return this.writer;
    }

    @Override
    public boolean isEofDeprecated() {
        return this.eofDeprecated;
    }

    @Override
    public boolean sessionStateAware() {
        return (this.serverCapabilities & 0x800000L) != 0L;
    }

    @Override
    public String getTraces() {
        if (this.options.enablePacketDebug) {
            return this.traceCache.printStack();
        }
        return "";
    }
}

