/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.logging;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.logging.Logger;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.logging.NoLogger;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.logging.Slf4JLogger;

public class LoggerFactory {
    public static final Logger NO_LOGGER = new NoLogger();
    public static Boolean hasToLog = null;
    public static Class loggerClass = null;
    public static Method method = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(boolean mustLog) {
        if (hasToLog != null && hasToLog == mustLog || !mustLog) return;
        Class<LoggerFactory> clazz = LoggerFactory.class;
        synchronized (LoggerFactory.class) {
            if (hasToLog != null && hasToLog == mustLog) return;
            try {
                loggerClass = Class.forName("org.slf4j.LoggerFactory");
                method = loggerClass.getMethod("getLogger", Class.class);
                hasToLog = Boolean.TRUE;
            }
            catch (ClassNotFoundException classNotFound) {
                System.out.println("Logging cannot be activated, missing slf4j dependency");
                hasToLog = Boolean.FALSE;
            }
            catch (NoSuchMethodException classNotFound) {
                System.out.println("Logging cannot be activated, missing slf4j dependency");
                hasToLog = Boolean.FALSE;
            }
            return;
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        if (hasToLog != null && hasToLog.booleanValue()) {
            try {
                return new Slf4JLogger((org.slf4j.Logger)method.invoke((Object)loggerClass, clazz));
            }
            catch (IllegalAccessException illegalAccess) {
                return null;
            }
            catch (InvocationTargetException invocationException) {
                return null;
            }
        }
        return NO_LOGGER;
    }
}

