/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.io;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.TraceObject;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.Utils;

public class LruTraceCache
extends LinkedHashMap<Long, TraceObject> {
    public LruTraceCache() {
        super(16, 1.0f, false);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<Long, TraceObject> eldest) {
        return this.size() > 10;
    }

    public String printStack() {
        StringBuilder sb = new StringBuilder();
        Set set = this.entrySet();
        for (Map.Entry entry : set) {
            TraceObject traceObj = (TraceObject)entry.getValue();
            long millis = (Long)entry.getKey();
            String indicator = "";
            switch (traceObj.getIndicatorFlag()) {
                case 0: {
                    break;
                }
                case 2: {
                    indicator = " (compressed protocol - packet not compressed)";
                    break;
                }
                case 1: {
                    indicator = " (compressed protocol - packet compressed)";
                    break;
                }
            }
            if (traceObj.isSend()) {
                sb.append("\nsend at " + new Date(millis) + indicator);
            } else {
                sb.append("\nread at " + new Date(millis) + indicator);
            }
            sb.append(Utils.hexdump(traceObj.getBuf()));
            traceObj.remove();
        }
        this.clear();
        return sb.toString();
    }

    public void clearMemory() {
        Set set = this.entrySet();
        for (Map.Entry entry : set) {
            ((TraceObject)entry.getValue()).remove();
        }
        this.clear();
    }
}

