/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.failover.thread;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.failover.Listener;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.failover.thread.TerminableRunnable;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.failover.tools.SearchFilter;

public class FailoverLoop
extends TerminableRunnable {
    private static final ConcurrentLinkedQueue<Listener> queue = new ConcurrentLinkedQueue();

    public FailoverLoop(ScheduledExecutorService scheduler) {
        super(scheduler, 1L, 1L, TimeUnit.SECONDS);
    }

    public static void addListener(Listener listener) {
        queue.add(listener);
    }

    public static void removeListener(Listener listener) {
        queue.remove(listener);
    }

    @Override
    protected void doRun() {
        Listener listener;
        while (!this.isUnschedule() && (listener = queue.poll()) != null) {
            if (listener.isExplicitClosed() || !listener.hasHostFail() || !listener.canRetryFailLoop()) continue;
            try {
                SearchFilter filter = listener.getFilterForFailedHost();
                filter.setFailoverLoop(true);
                listener.reconnectFailedConnection(filter);
                if (!listener.hasHostFail() || listener.isExplicitClosed()) continue;
                queue.add(listener);
            }
            catch (Exception e) {
                queue.add(listener);
            }
        }
    }
}

