/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.failover;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;
import me.lucko.helper.sql.external.mariadb.jdbc.HostAddress;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.failover.HandleErrorResult;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.failover.Listener;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.logging.Logger;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.logging.LoggerFactory;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol.Protocol;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.dao.ServerPrepareResult;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.exceptions.ExceptionMapper;

public class FailoverProxy
implements InvocationHandler {
    public static final String METHOD_IS_EXPLICIT_CLOSED = "isExplicitClosed";
    public static final String METHOD_GET_OPTIONS = "getOptions";
    public static final String METHOD_GET_PROXY = "getProxy";
    public static final String METHOD_EXECUTE_QUERY = "executeQuery";
    public static final String METHOD_SET_READ_ONLY = "setReadonly";
    public static final String METHOD_IS_READ_ONLY = "isReadOnly";
    public static final String METHOD_CLOSED_EXPLICIT = "closeExplicit";
    public static final String METHOD_IS_CLOSED = "isClosed";
    public static final String METHOD_EXECUTE_PREPARED_QUERY = "executePreparedQuery";
    public static final String METHOD_COM_MULTI_PREPARE_EXECUTES = "prepareAndExecutesComMulti";
    public static final String METHOD_PROLOG_PROXY = "prologProxy";
    private static Logger logger = LoggerFactory.getLogger(FailoverProxy.class);
    public final ReentrantLock lock;
    private Listener listener;

    public FailoverProxy(Listener listener, ReentrantLock lock) throws SQLException {
        this.lock = lock;
        this.listener = listener;
        this.listener.setProxy(this);
        this.listener.initializeConnection();
    }

    private static SQLException addHostInformationToException(SQLException exception, Protocol protocol) {
        if (protocol != null) {
            return new SQLException(exception.getMessage() + "\non " + protocol.getHostAddress().toString() + ",master=" + protocol.isMasterConnection(), exception.getSQLState(), exception.getErrorCode(), exception.getCause());
        }
        return exception;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        switch (methodName = method.getName()) {
            case "isExplicitClosed": {
                return this.listener.isExplicitClosed();
            }
            case "getOptions": {
                return this.listener.getUrlParser().getOptions();
            }
            case "getProxy": {
                return this;
            }
            case "isClosed": {
                return this.listener.isClosed();
            }
            case "executeQuery": {
                try {
                    this.listener.preExecute();
                    break;
                }
                catch (SQLException e) {
                    if (!this.hasToHandleFailover(e)) break;
                    return this.handleFailOver(e, method, args, this.listener.getCurrentProtocol());
                }
            }
            case "setReadonly": {
                this.listener.switchReadOnlyConnection((Boolean)args[0]);
                return null;
            }
            case "isReadOnly": {
                return this.listener.isReadOnly();
            }
            case "closeExplicit": {
                this.listener.preClose();
                return null;
            }
            case "prepareAndExecutesComMulti": 
            case "executePreparedQuery": {
                boolean mustBeOnMaster = (Boolean)args[0];
                ServerPrepareResult serverPrepareResult = (ServerPrepareResult)args[1];
                if (serverPrepareResult == null) break;
                if (!mustBeOnMaster && serverPrepareResult.getUnProxiedProtocol().isMasterConnection() && !this.listener.hasHostFail()) {
                    try {
                        logger.trace("re-prepare query \"" + serverPrepareResult.getSql() + "\" on slave (was temporary on master since failover)");
                        this.listener.rePrepareOnSlave(serverPrepareResult, mustBeOnMaster);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                try {
                    return this.listener.invoke(method, args, serverPrepareResult.getUnProxiedProtocol());
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() != null) {
                        if (e.getTargetException() instanceof SQLException && this.hasToHandleFailover((SQLException)e.getTargetException())) {
                            return this.handleFailOver((SQLException)e.getTargetException(), method, args, serverPrepareResult.getUnProxiedProtocol());
                        }
                        throw e.getTargetException();
                    }
                    throw e;
                }
            }
            case "prologProxy": {
                try {
                    if (args[0] != null) {
                        return this.listener.invoke(method, args, ((ServerPrepareResult)args[0]).getUnProxiedProtocol());
                    }
                    break;
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() != null) {
                        if (e.getTargetException() instanceof SQLException && this.hasToHandleFailover((SQLException)e.getTargetException())) {
                            return this.handleFailOver((SQLException)e.getTargetException(), method, args, ((ServerPrepareResult)args[0]).getUnProxiedProtocol());
                        }
                        throw e.getTargetException();
                    }
                    throw e;
                }
            }
        }
        return this.executeInvocation(method, args, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeInvocation(Method method, Object[] args, boolean isSecondExecution) throws Throwable {
        try {
            return this.listener.invoke(method, args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                if (e.getTargetException() instanceof SQLException) {
                    SQLException queryException = (SQLException)e.getTargetException();
                    Protocol protocol = this.listener.getCurrentProtocol();
                    if (this.hasToHandleFailover(queryException = FailoverProxy.addHostInformationToException(queryException, protocol))) {
                        return this.handleFailOver(queryException, method, args, protocol);
                    }
                    if (queryException.getErrorCode() == 1290 && !isSecondExecution && protocol != null && protocol.isMasterConnection() && !protocol.checkIfMaster()) {
                        boolean isReconnected;
                        boolean inTransaction = protocol.inTransaction();
                        this.lock.lock();
                        try {
                            protocol.close();
                            isReconnected = this.listener.primaryFail(null, null).isReconnected;
                        }
                        finally {
                            this.lock.unlock();
                        }
                        if (isReconnected && !inTransaction) {
                            return this.executeInvocation(method, args, true);
                        }
                        return this.handleFailOver(queryException, method, args, this.listener.getCurrentProtocol());
                    }
                }
                throw e.getTargetException();
            }
            throw e;
        }
    }

    private Object handleFailOver(SQLException qe, Method method, Object[] args, Protocol protocol) throws Throwable {
        HostAddress failHostAddress = null;
        boolean failIsMaster = true;
        if (protocol != null) {
            failHostAddress = protocol.getHostAddress();
            failIsMaster = protocol.isMasterConnection();
        }
        HandleErrorResult handleErrorResult = this.listener.handleFailover(qe, method, args, protocol);
        if (handleErrorResult.mustThrowError) {
            this.listener.throwFailoverMessage(failHostAddress, failIsMaster, qe, handleErrorResult.isReconnected);
        }
        return handleErrorResult.resultObject;
    }

    public boolean hasToHandleFailover(SQLException exception) {
        return exception.getSQLState() != null && exception.getSQLState().startsWith("08");
    }

    public void reconnect() throws SQLException {
        try {
            this.listener.reconnect();
        }
        catch (SQLException e) {
            ExceptionMapper.throwException(e, null, null);
        }
    }

    public Listener getListener() {
        return this.listener;
    }
}

