/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.parameters;

import java.io.IOException;
import java.io.Reader;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.ColumnType;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.output.PacketOutputStream;

public class ReaderParameter
implements Cloneable,
ParameterHolder {
    private Reader reader;
    private long length;
    private boolean noBackslashEscapes;

    public ReaderParameter(Reader reader, long length, boolean noBackslashEscapes) {
        this.reader = reader;
        this.length = length;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    public ReaderParameter(Reader reader, boolean noBackslashEscapes) {
        this(reader, Long.MAX_VALUE, noBackslashEscapes);
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException {
        pos.write(39);
        if (this.length == Long.MAX_VALUE) {
            pos.write(this.reader, true, this.noBackslashEscapes);
        } else {
            pos.write(this.reader, this.length, true, this.noBackslashEscapes);
        }
        pos.write(39);
    }

    @Override
    public long getApproximateTextProtocolLength() throws IOException {
        return -1L;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        if (this.length == Long.MAX_VALUE) {
            pos.write(this.reader, false, this.noBackslashEscapes);
        } else {
            pos.write(this.reader, this.length, false, this.noBackslashEscapes);
        }
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.STRING;
    }

    @Override
    public String toString() {
        return "<Reader>";
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return true;
    }
}

