/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.parameters;

import java.io.IOException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.ColumnType;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.output.PacketOutputStream;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.Options;

public class DateParameter
implements Cloneable,
ParameterHolder {
    private Date date;
    private TimeZone timeZone;
    private Options options;

    public DateParameter(Date date, TimeZone timeZone, Options options) {
        this.date = date;
        this.timeZone = timeZone;
        this.options = options;
    }

    @Override
    public void writeTo(PacketOutputStream os) throws IOException {
        os.write(39);
        os.write(this.dateByteFormat());
        os.write(39);
    }

    private byte[] dateByteFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (this.options.useLegacyDatetimeCode || this.options.maximizeMysqlCompatibility) {
            this.timeZone = Calendar.getInstance().getTimeZone();
        }
        sdf.setTimeZone(this.timeZone);
        return sdf.format(this.date).getBytes();
    }

    @Override
    public long getApproximateTextProtocolLength() {
        return 16L;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTimeInMillis(this.date.getTime());
        pos.write(7);
        pos.writeShort((short)calendar.get(1));
        pos.write((byte)(calendar.get(2) + 1 & 0xFF));
        pos.write((byte)(calendar.get(5) & 0xFF));
        pos.write(0);
        pos.write(0);
        pos.write(0);
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.DATE;
    }

    @Override
    public String toString() {
        return "'" + this.date.toString() + "'";
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return false;
    }
}

