/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.gssapi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.Buffer;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.gssapi.GssapiAuth;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.input.PacketInputStream;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.output.PacketOutputStream;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class StandardGssapiAuthentication
extends GssapiAuth {
    public StandardGssapiAuthentication(PacketInputStream reader, int packSeq) {
        super(reader, packSeq);
    }

    @Override
    public void authenticate(final PacketOutputStream writer, final String serverPrincipalName, String mechanisms) throws SQLException, IOException {
        block22: {
            if ("".equals(serverPrincipalName)) {
                throw new SQLException("No principal name defined on server. Please set server variable \"gssapi-principal-name\"", "28000");
            }
            if (System.getProperty("java.security.auth.login.config") == null) {
                File jaasConfFile;
                try {
                    jaasConfFile = File.createTempFile("jaas.conf", null);
                    try (PrintStream bos = new PrintStream(new FileOutputStream(jaasConfFile));){
                        bos.print(String.format("Krb5ConnectorContext {\ncom.sun.security.auth.module.Krb5LoginModule required useTicketCache=true debug=true renewTGT=true doNotPrompt=true; };", new Object[0]));
                    }
                    jaasConfFile.deleteOnExit();
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                System.setProperty("java.security.auth.login.config", jaasConfFile.getCanonicalPath());
            }
            try {
                LoginContext loginContext = new LoginContext("Krb5ConnectorContext");
                loginContext.login();
                Subject mySubject = loginContext.getSubject();
                if (!mySubject.getPrincipals().isEmpty()) {
                    try {
                        PrivilegedExceptionAction<Void> action = new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws Exception {
                                try {
                                    Oid krb5Mechanism = new Oid("1.2.840.113554.1.2.2");
                                    GSSManager manager = GSSManager.getInstance();
                                    GSSName peerName = manager.createName(serverPrincipalName, GSSName.NT_USER_NAME);
                                    GSSContext context = manager.createContext(peerName, krb5Mechanism, null, 0);
                                    context.requestMutualAuth(true);
                                    byte[] inToken = new byte[]{};
                                    while (!context.isEstablished()) {
                                        byte[] outToken = context.initSecContext(inToken, 0, inToken.length);
                                        if (outToken != null) {
                                            writer.startPacket(StandardGssapiAuthentication.this.packSeq);
                                            writer.write(outToken);
                                            writer.flush();
                                        }
                                        if (context.isEstablished()) continue;
                                        Buffer buffer = StandardGssapiAuthentication.this.reader.getPacket(true);
                                        StandardGssapiAuthentication.this.packSeq = StandardGssapiAuthentication.this.reader.getLastPacketSeq() + 1;
                                        inToken = buffer.readRawBytes(buffer.remaining());
                                    }
                                }
                                catch (GSSException le) {
                                    throw new SQLException("GSS-API authentication exception", "28000", 1045, le);
                                }
                                return null;
                            }
                        };
                        Subject.doAs(mySubject, action);
                        break block22;
                    }
                    catch (PrivilegedActionException exception) {
                        throw new SQLException("GSS-API authentication exception", "28000", 1045, exception);
                    }
                }
                throw new SQLException("GSS-API authentication exception : no credential cache not found.", "28000", 1045);
            }
            catch (LoginException le) {
                throw new SQLException("GSS-API authentication exception", "28000", 1045, le);
            }
        }
    }
}

