/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send;

import java.awt.HeadlessException;
import java.io.Console;
import java.io.EOFException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.Buffer;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.ErrorPacket;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.AbstractAuthSwitchSendResponsePacket;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.InterfaceAuthSwitchSendResponsePacket;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.input.PacketInputStream;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.output.PacketOutputStream;

public class SendPamAuthPacket
extends AbstractAuthSwitchSendResponsePacket
implements InterfaceAuthSwitchSendResponsePacket {
    private PacketInputStream reader;

    public SendPamAuthPacket(PacketInputStream reader, String password, byte[] authData, int packSeq, String passwordCharacterEncoding) {
        super(packSeq, authData, password, passwordCharacterEncoding);
        this.reader = reader;
    }

    @Override
    public void send(PacketOutputStream pos) throws IOException, SQLException {
        byte type = this.authData[0];
        while (true) {
            String promptb;
            if ("Password: ".equals(promptb = new String(Arrays.copyOfRange(this.authData, 1, this.authData.length))) && this.password != null && !"".equals(this.password)) {
                pos.startPacket(this.packSeq);
                byte[] bytePwd = this.passwordCharacterEncoding != null && !this.passwordCharacterEncoding.isEmpty() ? this.password.getBytes(this.passwordCharacterEncoding) : this.password.getBytes();
                pos.write(bytePwd, 0, bytePwd.length);
                pos.write(0);
            } else {
                boolean isPassword = type == 4;
                String password = this.showInputDialog(promptb, isPassword);
                if (password == null) {
                    throw new SQLException("Error during PAM authentication : dialog input cancelled");
                }
                pos.startPacket(this.packSeq);
                byte[] bytePwd = this.passwordCharacterEncoding != null && !this.passwordCharacterEncoding.isEmpty() ? password.getBytes(this.passwordCharacterEncoding) : password.getBytes();
                pos.write(bytePwd, 0, bytePwd.length);
                pos.write(0);
            }
            pos.flush();
            try {
                Buffer buffer = this.reader.getPacket(true);
                this.packSeq = this.reader.getLastPacketSeq() + 1;
                type = buffer.getByteAt(0);
                if (type == -2 || type == 0) {
                    return;
                }
                if (type == -1) {
                    ErrorPacket errorPacket = new ErrorPacket(buffer);
                    throw new SQLException("Error during PAM authentication : " + errorPacket.getMessage());
                }
                this.authData = buffer.readRawBytes(buffer.remaining());
            }
            catch (EOFException eof) {
                throw new SQLException("Error during PAM authentication reading server response : " + eof.getMessage() + "\nPlease check that value of @@connect_timeout is not too low.");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String showInputDialog(String label, boolean isPassword) throws IOException {
        String password;
        try {
            if (isPassword) {
                JPasswordField pwd = new JPasswordField();
                pwd.addAncestorListener(new RequestFocusListener());
                int action = JOptionPane.showConfirmDialog(null, pwd, label, 2);
                if (action != 0) throw new IOException("Error during PAM authentication : dialog input cancelled");
                password = new String(pwd.getPassword());
            } else {
                password = JOptionPane.showInputDialog(label);
            }
        }
        catch (HeadlessException noGraphicalEnvironment) {
            Console console = System.console();
            if (console == null) {
                throw new IOException("Error during PAM authentication : input by console not possible");
            }
            if (isPassword) {
                char[] passwordChar = console.readPassword(label, new Object[0]);
                password = new String(passwordChar);
            }
            password = console.readLine(label, new Object[0]);
        }
        if (password == null) throw new IOException("Error during PAM authentication : dialog input cancelled");
        return password;
    }

    @Override
    public void handleResultPacket(PacketInputStream reader) throws SQLException, IOException {
    }

    public class RequestFocusListener
    implements AncestorListener {
        private boolean removeListener;

        public RequestFocusListener() {
            this(true);
        }

        public RequestFocusListener(boolean removeListener) {
            this.removeListener = removeListener;
        }

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            JComponent component = ancestorEvent.getComponent();
            component.requestFocusInWindow();
            if (this.removeListener) {
                component.removeAncestorListener(this);
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }
    }
}

