/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send;

import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.Buffer;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.ErrorPacket;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.AbstractAuthSwitchSendResponsePacket;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.InterfaceAuthSwitchSendResponsePacket;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.gssapi.GssapiAuth;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.gssapi.StandardGssapiAuthentication;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.gssapi.WindowsNativeSspiAuthentication;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.input.PacketInputStream;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.output.PacketOutputStream;

public class SendGssApiAuthPacket
extends AbstractAuthSwitchSendResponsePacket
implements InterfaceAuthSwitchSendResponsePacket {
    private PacketInputStream reader;

    public SendGssApiAuthPacket(PacketInputStream reader, String password, byte[] authData, int packSeq, String passwordCharacterEncoding) {
        super(packSeq, authData, password, passwordCharacterEncoding);
        this.reader = reader;
    }

    @Override
    public void send(PacketOutputStream pos) throws IOException, SQLException {
        Buffer buffer = new Buffer(this.authData);
        String serverPrincipalName = buffer.readStringNullEnd(StandardCharsets.UTF_8);
        String mechanisms = buffer.readStringNullEnd(StandardCharsets.UTF_8);
        if (mechanisms.equals("")) {
            mechanisms = "Kerberos";
        }
        GssapiAuth gssapiAuth = this.getAuthenticationMethod();
        gssapiAuth.authenticate(pos, serverPrincipalName, mechanisms);
    }

    @Override
    public void handleResultPacket(PacketInputStream reader) throws SQLException, IOException {
        try {
            Buffer buffer = reader.getPacket(true);
            if (buffer.getByteAt(0) == -1) {
                ErrorPacket ep = new ErrorPacket(buffer);
                String message = ep.getMessage();
                throw new SQLException("Could not connect: " + message, ep.getSqlState(), ep.getErrorNumber());
            }
        }
        catch (EOFException e) {
            throw new SQLException("Authentication exception", "28000", 1045, e);
        }
    }

    private GssapiAuth getAuthenticationMethod() {
        try {
            Class<?> platformClass = Class.forName("com.sun.jna.Platform");
            Method method = platformClass.getMethod("isWindows", new Class[0]);
            Boolean isWindows = (Boolean)method.invoke(platformClass, new Object[0]);
            if (isWindows.booleanValue()) {
                try {
                    Class.forName("waffle.windows.auth.impl.WindowsAuthProviderImpl");
                    return new WindowsNativeSspiAuthentication(this.reader, this.packSeq);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new StandardGssapiAuthentication(this.reader, this.packSeq);
    }
}

