/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Deque;
import me.lucko.helper.sql.external.mariadb.jdbc.MariaDbStatement;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.dao.CmdInformation;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.dao.CmdInformationBatch;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.dao.CmdInformationMultiple;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.dao.CmdInformationSingle;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.resultset.SelectResultSet;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol.Protocol;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.exceptions.ExceptionMapper;

public class Results {
    private MariaDbStatement statement;
    private int fetchSize;
    private boolean batch;
    private int expectedSize;
    private CmdInformation cmdInformation;
    private Deque<SelectResultSet> executionResults;
    private SelectResultSet resultSet;
    private SelectResultSet callableResultSet;
    private boolean binaryFormat;
    private int resultSetScrollType;
    private int maxFieldSize;
    private int autoIncrement;

    public Results() {
        this.statement = null;
        this.fetchSize = 0;
        this.maxFieldSize = 0;
        this.batch = false;
        this.expectedSize = 1;
        this.cmdInformation = null;
        this.binaryFormat = false;
        this.resultSetScrollType = 1003;
        this.autoIncrement = 1;
    }

    public Results(MariaDbStatement statement, int autoIncrement) {
        this.statement = statement;
        this.fetchSize = 0;
        this.maxFieldSize = 0;
        this.batch = false;
        this.expectedSize = 1;
        this.cmdInformation = null;
        this.binaryFormat = false;
        this.resultSetScrollType = 1003;
        this.autoIncrement = autoIncrement;
    }

    public Results(MariaDbStatement statement, int fetchSize, boolean batch, int expectedSize, boolean binaryFormat, int resultSetScrollType, int autoIncrement) {
        this.statement = statement;
        this.fetchSize = fetchSize;
        this.batch = batch;
        this.maxFieldSize = statement.getMaxFieldSize();
        this.expectedSize = expectedSize;
        this.cmdInformation = null;
        this.binaryFormat = binaryFormat;
        this.resultSetScrollType = resultSetScrollType;
        this.autoIncrement = autoIncrement;
    }

    public void reset(int fetchSize, boolean batch, int expectedSize, boolean binaryFormat, int resultSetScrollType) {
        this.fetchSize = fetchSize;
        this.batch = batch;
        this.maxFieldSize = this.statement.getMaxFieldSize();
        this.expectedSize = expectedSize;
        this.cmdInformation = null;
        this.binaryFormat = binaryFormat;
        this.resultSetScrollType = resultSetScrollType;
    }

    public void addStats(long updateCount, long insertId, boolean moreResultAvailable) {
        if (this.cmdInformation == null) {
            if (this.batch) {
                this.cmdInformation = new CmdInformationBatch(this.expectedSize, this.autoIncrement);
            } else if (moreResultAvailable) {
                this.cmdInformation = new CmdInformationMultiple(this.expectedSize, this.autoIncrement);
            } else {
                this.cmdInformation = new CmdInformationSingle(insertId, updateCount, this.autoIncrement);
                return;
            }
        }
        this.cmdInformation.addSuccessStat(updateCount, insertId);
    }

    public void addStatsError(boolean moreResultAvailable) {
        if (this.cmdInformation == null) {
            if (this.batch) {
                this.cmdInformation = new CmdInformationBatch(this.expectedSize, this.autoIncrement);
            } else if (moreResultAvailable) {
                this.cmdInformation = new CmdInformationMultiple(this.expectedSize, this.autoIncrement);
            } else {
                this.cmdInformation = new CmdInformationSingle(0L, -3L, this.autoIncrement);
                return;
            }
        }
        this.cmdInformation.addErrorStat();
    }

    public int getCurrentStatNumber() {
        return this.cmdInformation == null ? 0 : this.cmdInformation.getCurrentStatNumber();
    }

    public void addResultSet(SelectResultSet resultSet, boolean moreResultAvailable) {
        if (resultSet.isCallableResult()) {
            this.callableResultSet = resultSet;
            return;
        }
        if (this.executionResults == null) {
            this.executionResults = new ArrayDeque<SelectResultSet>();
        }
        this.executionResults.add(resultSet);
        if (this.cmdInformation == null) {
            if (this.batch) {
                this.cmdInformation = new CmdInformationBatch(this.expectedSize, this.autoIncrement);
            } else if (moreResultAvailable) {
                this.cmdInformation = new CmdInformationMultiple(this.expectedSize, this.autoIncrement);
            } else {
                this.cmdInformation = new CmdInformationSingle(0L, -1L, this.autoIncrement);
                return;
            }
        }
        this.cmdInformation.addResultSetStat();
    }

    public CmdInformation getCmdInformation() {
        return this.cmdInformation;
    }

    protected void setCmdInformation(CmdInformation cmdInformation) {
        this.cmdInformation = cmdInformation;
    }

    public Results commandEnd() {
        this.resultSet = this.cmdInformation != null && this.executionResults != null && !this.cmdInformation.isCurrentUpdateCount() ? this.executionResults.poll() : null;
        return this;
    }

    public SelectResultSet getResultSet() {
        return this.resultSet;
    }

    public SelectResultSet getCallableResultSet() {
        return this.callableResultSet;
    }

    public void loadFully(boolean skip, Protocol protocol) throws SQLException {
        if (this.fetchSize != 0) {
            this.fetchSize = 0;
            if (this.resultSet != null) {
                if (skip) {
                    this.resultSet.close();
                } else {
                    this.resultSet.fetchRemaining();
                }
            } else {
                SelectResultSet firstResult = this.executionResults.peekFirst();
                if (firstResult != null) {
                    if (skip) {
                        firstResult.close();
                    } else {
                        firstResult.fetchRemaining();
                    }
                }
            }
        }
        if (protocol.hasMoreResults()) {
            protocol.getResult(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMoreResults(int current, Protocol protocol) throws SQLException {
        if (this.fetchSize != 0 && this.resultSet != null) {
            protocol.getLock().lock();
            try {
                if (current == 1 && this.resultSet != null) {
                    this.resultSet.close();
                } else {
                    this.resultSet.fetchRemaining();
                }
                if (protocol.hasMoreResults()) {
                    protocol.getResult(this);
                }
            }
            catch (SQLException e) {
                ExceptionMapper.throwException(e, null, this.statement);
            }
            finally {
                protocol.getLock().unlock();
            }
        }
        if (this.cmdInformation.moreResults() && !this.batch) {
            if (current == 1 && this.resultSet != null) {
                this.resultSet.close();
            }
            this.resultSet = null;
            return true;
        }
        if (current == 1 && this.resultSet != null) {
            this.resultSet.close();
        }
        if (this.executionResults != null) {
            this.resultSet = this.executionResults.poll();
        }
        return this.resultSet != null;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public MariaDbStatement getStatement() {
        return this.statement;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public int getExpectedSize() {
        return this.expectedSize;
    }

    public boolean isBinaryFormat() {
        return this.binaryFormat;
    }

    public void removeFetchSize() {
        this.fetchSize = 0;
    }

    public int getResultSetScrollType() {
        return this.resultSetScrollType;
    }

    public ResultSet getGeneratedKeys(Protocol protocol) {
        if (this.cmdInformation != null) {
            if (this.batch) {
                return this.cmdInformation.getBatchGeneratedKeys(protocol);
            }
            return this.cmdInformation.getGeneratedKeys(protocol);
        }
        return SelectResultSet.createEmptyResultSet();
    }

    public void close() {
        this.statement = null;
        this.fetchSize = 0;
    }

    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    public void setAutoIncrement(int autoIncrement) {
        this.autoIncrement = autoIncrement;
    }
}

