/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.dao;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.resultset.ColumnInformation;

public class ColumnNameMap {
    Map<String, Integer> map;
    Map<String, Integer> labelMap;
    ColumnInformation[] columnInfo;

    public ColumnNameMap(ColumnInformation[] columnInformations) {
        this.columnInfo = columnInformations;
    }

    public int getIndex(String name) throws SQLException {
        if (this.columnInfo == null) {
            throw new SQLException("No such column :" + name);
        }
        Integer res = this.getLabelIndex(name);
        if (res != null) {
            return res;
        }
        if (this.map == null) {
            this.map = new HashMap<String, Integer>();
            int counter = 0;
            for (ColumnInformation ci : this.columnInfo) {
                String columnName = ci.getOriginalName().toLowerCase();
                if (columnName.equals("")) {
                    columnName = ci.getName().toLowerCase();
                }
                this.map.put(columnName, counter);
                String tableName = ci.getTable().toLowerCase();
                if (!tableName.equals("")) {
                    this.map.put(tableName + "." + columnName, counter);
                }
                ++counter;
            }
        }
        if ((res = this.map.get(name.toLowerCase())) == null) {
            throw new SQLException("No such column :" + name);
        }
        return res;
    }

    private int getLabelIndex(String name) throws SQLException {
        Integer res;
        if (this.labelMap == null) {
            this.labelMap = new HashMap<String, Integer>();
            int counter = 0;
            for (ColumnInformation ci : this.columnInfo) {
                String tableName;
                String columnAlias = ci.getName().toLowerCase();
                if (!this.labelMap.containsKey(columnAlias)) {
                    this.labelMap.put(columnAlias, counter);
                }
                if (ci.getTable() != null && !(tableName = ci.getTable().toLowerCase()).equals("") && !this.labelMap.containsKey(tableName + "." + columnAlias)) {
                    this.labelMap.put(tableName + "." + columnAlias, counter);
                }
                ++counter;
            }
        }
        if ((res = this.labelMap.get(name.toLowerCase())) == null) {
            throw new SQLException("No such column :" + name);
        }
        return res;
    }
}

