/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.dao;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.dao.CmdInformation;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.resultset.SelectResultSet;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol.Protocol;

public class CmdInformationMultiple
implements CmdInformation {
    private ArrayList<Long> insertIds;
    private ArrayList<Long> updateCounts;
    private int insertIdNumber = 0;
    private int expectedSize;
    private int autoIncrement;
    private int moreResults;
    private boolean hasException;

    public CmdInformationMultiple(int expectedSize, int autoIncrement) {
        this.expectedSize = expectedSize;
        this.insertIds = new ArrayList(expectedSize);
        this.updateCounts = new ArrayList(expectedSize);
        this.autoIncrement = autoIncrement;
    }

    @Override
    public void addErrorStat() {
        this.hasException = true;
        this.updateCounts.add(-3L);
    }

    @Override
    public void addResultSetStat() {
        this.updateCounts.add(-1L);
    }

    @Override
    public void addSuccessStat(long updateCount, long insertId) {
        this.insertIds.add(insertId);
        this.insertIdNumber = (int)((long)this.insertIdNumber + updateCount);
        this.updateCounts.add(updateCount);
    }

    @Override
    public int[] getUpdateCounts() {
        int[] ret = new int[Math.max(this.updateCounts.size(), this.expectedSize)];
        Iterator<Long> iterator = this.updateCounts.iterator();
        int pos = 0;
        while (iterator.hasNext()) {
            ret[pos++] = iterator.next().intValue();
        }
        while (pos < ret.length) {
            ret[pos++] = -3;
        }
        return ret;
    }

    @Override
    public long[] getLargeUpdateCounts() {
        long[] ret = new long[Math.max(this.updateCounts.size(), this.expectedSize)];
        Iterator<Long> iterator = this.updateCounts.iterator();
        int pos = 0;
        while (iterator.hasNext()) {
            ret[pos++] = iterator.next();
        }
        while (pos < ret.length) {
            ret[pos++] = -3L;
        }
        return ret;
    }

    public long[] getLargeRewriteUpdateCounts() {
        long[] ret = new long[this.expectedSize];
        Arrays.fill(ret, this.hasException ? -3L : -2L);
        return ret;
    }

    @Override
    public int[] getRewriteUpdateCounts() {
        int[] ret = new int[this.expectedSize];
        Arrays.fill(ret, this.hasException ? -3 : -2);
        return ret;
    }

    @Override
    public long[] getRewriteLargeUpdateCounts() {
        long[] ret = new long[this.expectedSize];
        Arrays.fill(ret, this.hasException ? -3L : -2L);
        return ret;
    }

    @Override
    public int getUpdateCount() {
        if (this.moreResults >= this.updateCounts.size()) {
            return -1;
        }
        return this.updateCounts.get(this.moreResults).intValue();
    }

    @Override
    public long getLargeUpdateCount() {
        if (this.moreResults >= this.updateCounts.size()) {
            return -1L;
        }
        return this.updateCounts.get(this.moreResults);
    }

    @Override
    public ResultSet getBatchGeneratedKeys(Protocol protocol) {
        long[] ret = new long[this.insertIdNumber];
        int position = 0;
        Iterator<Long> idIterator = this.insertIds.iterator();
        for (long updateCount : this.updateCounts) {
            long insertId;
            if (updateCount == -3L || updateCount == -1L || (insertId = idIterator.next().longValue()) <= 0L) continue;
            int i = 0;
            while ((long)i < updateCount) {
                ret[position++] = insertId + (long)(i * this.autoIncrement);
                ++i;
            }
        }
        return SelectResultSet.createGeneratedData(ret, protocol, true);
    }

    @Override
    public ResultSet getGeneratedKeys(Protocol protocol) {
        long[] ret = new long[this.insertIdNumber];
        int position = 0;
        Iterator<Long> idIterator = this.insertIds.iterator();
        Iterator<Long> updateIterator = this.updateCounts.iterator();
        for (int element = 0; element <= this.moreResults; ++element) {
            long insertId;
            long updateCount = updateIterator.next();
            if (updateCount == -3L || updateCount == -1L || (insertId = idIterator.next().longValue()) <= 0L || element != this.moreResults) continue;
            int i = 0;
            while ((long)i < updateCount) {
                ret[position++] = insertId + (long)(i * this.autoIncrement);
                ++i;
            }
        }
        return SelectResultSet.createGeneratedData(ret, protocol, true);
    }

    @Override
    public int getCurrentStatNumber() {
        return this.updateCounts.size();
    }

    @Override
    public boolean moreResults() {
        if (this.moreResults++ < this.updateCounts.size() - 1) {
            return this.updateCounts.get(this.moreResults) != -1L;
        }
        return false;
    }

    @Override
    public boolean isCurrentUpdateCount() {
        if (this.updateCounts.size() >= 0) {
            return this.updateCounts.get(this.moreResults) != -1L;
        }
        return true;
    }
}

