/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.dao;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.dao.CmdInformation;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.resultset.SelectResultSet;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol.Protocol;

public class CmdInformationBatch
implements CmdInformation {
    private Queue<Long> insertIds;
    private Queue<Long> updateCounts;
    private int insertIdNumber = 0;
    private int expectedSize;
    private int autoIncrement;
    private boolean hasException;

    public CmdInformationBatch(int expectedSize, int autoIncrement) {
        this.expectedSize = expectedSize;
        this.insertIds = new ConcurrentLinkedQueue<Long>();
        this.updateCounts = new ConcurrentLinkedQueue<Long>();
        this.autoIncrement = autoIncrement;
    }

    @Override
    public void addErrorStat() {
        this.hasException = true;
        this.updateCounts.add(-3L);
    }

    @Override
    public void addResultSetStat() {
        this.updateCounts.add(-1L);
    }

    @Override
    public void addSuccessStat(long updateCount, long insertId) {
        this.insertIds.add(insertId);
        this.insertIdNumber = (int)((long)this.insertIdNumber + updateCount);
        this.updateCounts.add(updateCount);
    }

    @Override
    public int[] getUpdateCounts() {
        int[] ret = new int[Math.max(this.updateCounts.size(), this.expectedSize)];
        Iterator iterator = this.updateCounts.iterator();
        int pos = 0;
        while (iterator.hasNext()) {
            ret[pos++] = ((Long)iterator.next()).intValue();
        }
        while (pos < ret.length) {
            ret[pos++] = -3;
        }
        return ret;
    }

    @Override
    public long[] getLargeUpdateCounts() {
        long[] ret = new long[Math.max(this.updateCounts.size(), this.expectedSize)];
        Iterator iterator = this.updateCounts.iterator();
        int pos = 0;
        while (iterator.hasNext()) {
            ret[pos++] = (Long)iterator.next();
        }
        while (pos < ret.length) {
            ret[pos++] = -3L;
        }
        return ret;
    }

    @Override
    public int[] getRewriteUpdateCounts() {
        int[] ret = new int[this.expectedSize];
        Arrays.fill(ret, this.hasException ? -3 : -2);
        return ret;
    }

    @Override
    public long[] getRewriteLargeUpdateCounts() {
        long[] ret = new long[this.expectedSize];
        Arrays.fill(ret, this.hasException ? -3L : -2L);
        return ret;
    }

    @Override
    public int getUpdateCount() {
        Long updateCount = this.updateCounts.peek();
        return updateCount == null ? -1 : updateCount.intValue();
    }

    @Override
    public long getLargeUpdateCount() {
        Long updateCount = this.updateCounts.peek();
        return updateCount == null ? -1L : updateCount;
    }

    @Override
    public ResultSet getBatchGeneratedKeys(Protocol protocol) {
        long[] ret = new long[this.insertIdNumber];
        int position = 0;
        Iterator idIterator = this.insertIds.iterator();
        Iterator updateIterator = this.updateCounts.iterator();
        while (updateIterator.hasNext()) {
            long insertId;
            int updateCount = ((Long)updateIterator.next()).intValue();
            if (updateCount == -3 || updateCount == -1 || (insertId = ((Long)idIterator.next()).longValue()) <= 0L) continue;
            for (int i = 0; i < updateCount; ++i) {
                ret[position++] = insertId + (long)(i * this.autoIncrement);
            }
        }
        return SelectResultSet.createGeneratedData(ret, protocol, true);
    }

    @Override
    public ResultSet getGeneratedKeys(Protocol protocol) {
        long[] ret = new long[this.insertIdNumber];
        int position = 0;
        Iterator idIterator = this.insertIds.iterator();
        Iterator updateIterator = this.updateCounts.iterator();
        while (updateIterator.hasNext()) {
            long insertId;
            int updateCount = ((Long)updateIterator.next()).intValue();
            if (updateCount == -3 || updateCount == -1 || (insertId = ((Long)idIterator.next()).longValue()) <= 0L) continue;
            for (int i = 0; i < updateCount; ++i) {
                ret[position++] = insertId + (long)(i * this.autoIncrement);
            }
        }
        return SelectResultSet.createGeneratedData(ret, protocol, true);
    }

    @Override
    public int getCurrentStatNumber() {
        return this.updateCounts.size();
    }

    @Override
    public boolean moreResults() {
        return false;
    }

    @Override
    public boolean isCurrentUpdateCount() {
        return false;
    }
}

