/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read;

import java.nio.charset.StandardCharsets;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.Buffer;

public class ErrorPacket {
    private final short errorNumber;
    private final byte sqlStateMarker;
    private final byte[] sqlState;
    private final String message;

    public ErrorPacket(Buffer buffer) {
        buffer.skipByte();
        this.errorNumber = buffer.readShort();
        this.sqlStateMarker = buffer.readByte();
        if (this.sqlStateMarker == 35) {
            this.sqlState = buffer.readRawBytes(5);
            this.message = buffer.readStringNullEnd(StandardCharsets.UTF_8);
        } else {
            --buffer.position;
            this.message = new String(buffer.buf, buffer.position, buffer.limit - buffer.position, StandardCharsets.UTF_8);
            this.sqlState = "HY000".getBytes();
        }
    }

    public String getMessage() {
        return this.message;
    }

    public short getErrorNumber() {
        return this.errorNumber;
    }

    public String getSqlState() {
        return new String(this.sqlState);
    }

    public byte getSqlStateMarker() {
        return this.sqlStateMarker;
    }
}

