/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import me.lucko.helper.sql.external.mariadb.jdbc.MariaDbConnection;
import me.lucko.helper.sql.external.mariadb.jdbc.MariaDbStatement;
import me.lucko.helper.sql.external.mariadb.jdbc.UrlParser;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol.Protocol;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.Utils;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.exceptions.ExceptionMapper;

public final class Driver
implements java.sql.Driver {
    public static void unloadDriver() {
        MariaDbStatement.unloadDriver();
    }

    @Override
    public Connection connect(String url, Properties props) throws SQLException {
        try {
            UrlParser urlParser = UrlParser.parse(url, props);
            if (urlParser == null) {
                return null;
            }
            if (urlParser.getHostAddresses() == null) {
                return null;
            }
            ReentrantLock lock = new ReentrantLock();
            Protocol protocol = Utils.retrieveProxy(urlParser, lock);
            return MariaDbConnection.newConnection(url, protocol, lock);
        }
        catch (SQLException e) {
            ExceptionMapper.throwException(e, null, null);
            return null;
        }
    }

    @Override
    public boolean acceptsURL(String url) {
        return UrlParser.acceptsUrl(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Use logging parameters for enabling logging.");
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not register driver", e);
        }
    }
}

