/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.hikari.metrics.prometheus;

import io.prometheus.client.Collector;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.lucko.helper.sql.external.hikari.metrics.PoolStats;

class HikariCPCollector
extends Collector {
    private final PoolStats poolStats;
    private final List<String> labelNames;
    private final List<String> labelValues;

    HikariCPCollector(String poolName, PoolStats poolStats) {
        this.poolStats = poolStats;
        this.labelNames = Collections.singletonList("pool");
        this.labelValues = Collections.singletonList(poolName);
    }

    public List<Collector.MetricFamilySamples> collect() {
        return Arrays.asList(this.createSample("hikaricp_active_connections", "Active connections", this.poolStats.getActiveConnections()), this.createSample("hikaricp_idle_connections", "Idle connections", this.poolStats.getIdleConnections()), this.createSample("hikaricp_pending_threads", "Pending threads", this.poolStats.getPendingThreads()), this.createSample("hikaricp_connections", "The number of current connections", this.poolStats.getTotalConnections()));
    }

    private Collector.MetricFamilySamples createSample(String name, String helpMessage, double value) {
        List<Collector.MetricFamilySamples.Sample> samples = Collections.singletonList(new Collector.MetricFamilySamples.Sample(name, this.labelNames, this.labelValues, value));
        return new Collector.MetricFamilySamples(name, Collector.Type.GAUGE, helpMessage, samples);
    }
}

