/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params.geo;

import java.util.ArrayList;
import me.lucko.helper.redis.external.jedisutil.SafeEncoder;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.params.Params;

public class GeoRadiusParam
extends Params {
    private static final String WITHCOORD = "withcoord";
    private static final String WITHDIST = "withdist";
    private static final String ASC = "asc";
    private static final String DESC = "desc";
    private static final String COUNT = "count";

    private GeoRadiusParam() {
    }

    public static GeoRadiusParam geoRadiusParam() {
        return new GeoRadiusParam();
    }

    public GeoRadiusParam withCoord() {
        this.addParam(WITHCOORD);
        return this;
    }

    public GeoRadiusParam withDist() {
        this.addParam(WITHDIST);
        return this;
    }

    public GeoRadiusParam sortAscending() {
        this.addParam(ASC);
        return this;
    }

    public GeoRadiusParam sortDescending() {
        this.addParam(DESC);
        return this;
    }

    public GeoRadiusParam count(int count) {
        if (count > 0) {
            this.addParam(COUNT, count);
        }
        return this;
    }

    public byte[][] getByteParams(byte[] ... args) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        for (byte[] arg : args) {
            byteParams.add(arg);
        }
        if (this.contains(WITHCOORD)) {
            byteParams.add(SafeEncoder.encode(WITHCOORD));
        }
        if (this.contains(WITHDIST)) {
            byteParams.add(SafeEncoder.encode(WITHDIST));
        }
        if (this.contains(COUNT)) {
            byteParams.add(SafeEncoder.encode(COUNT));
            byteParams.add(Protocol.toByteArray((Integer)this.getParam(COUNT)));
        }
        if (this.contains(ASC)) {
            byteParams.add(SafeEncoder.encode(ASC));
        } else if (this.contains(DESC)) {
            byteParams.add(SafeEncoder.encode(DESC));
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }
}

