/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.redis.plugin;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import me.lucko.helper.messaging.Messenger;
import me.lucko.helper.plugin.ExtendedJavaPlugin;
import me.lucko.helper.redis.Redis;
import me.lucko.helper.redis.RedisCredentials;
import me.lucko.helper.redis.RedisProvider;
import me.lucko.helper.redis.plugin.HelperRedis;
import me.lucko.helper.terminable.TerminableConsumer;
import org.bukkit.configuration.ConfigurationSection;

public class HelperRedisPlugin
extends ExtendedJavaPlugin
implements RedisProvider {
    private RedisCredentials globalCredentials;
    private Redis globalRedis;

    protected void enable() {
        this.globalCredentials = RedisCredentials.fromConfig((ConfigurationSection)this.loadConfig("config.yml"));
        this.globalRedis = this.getRedis(this.globalCredentials);
        this.globalRedis.bindWith((TerminableConsumer)this);
        this.provideService(RedisProvider.class, this);
        this.provideService(RedisCredentials.class, this.globalCredentials);
        this.provideService(Redis.class, this.globalRedis);
        this.provideService(Messenger.class, this.globalRedis);
    }

    @Override
    @Nonnull
    public Redis getRedis() {
        return this.globalRedis;
    }

    @Override
    @Nonnull
    public Redis getRedis(@Nonnull RedisCredentials credentials) {
        return CompletableFuture.supplyAsync(() -> new HelperRedis(credentials)).join();
    }

    @Override
    @Nonnull
    public RedisCredentials getGlobalCredentials() {
        return this.globalCredentials;
    }
}

