/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.redis.plugin;

import com.google.common.reflect.TypeToken;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import me.lucko.helper.Schedulers;
import me.lucko.helper.messaging.AbstractMessenger;
import me.lucko.helper.messaging.Channel;
import me.lucko.helper.redis.Redis;
import me.lucko.helper.redis.RedisCredentials;
import me.lucko.helper.redis.external.commonspool2.impl.GenericObjectPoolConfig;
import me.lucko.helper.terminable.TerminableConsumer;
import me.lucko.helper.terminable.composite.CompositeTerminable;
import me.lucko.helper.utils.Log;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class HelperRedis
implements Redis {
    private final JedisPool jedisPool;
    private final AbstractMessenger messenger;
    private PubSubListener listener = null;
    private Set<String> channels = new HashSet<String>();
    private CompositeTerminable registry = CompositeTerminable.create();

    public HelperRedis(@Nonnull RedisCredentials credentials) {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(16);
        this.jedisPool = credentials.getPassword().trim().isEmpty() ? new JedisPool((GenericObjectPoolConfig)config, credentials.getAddress(), credentials.getPort()) : new JedisPool((GenericObjectPoolConfig)config, credentials.getAddress(), credentials.getPort(), 2000, credentials.getPassword());
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.ping();
        }
        Schedulers.async().run(new Runnable(){
            private boolean broken = false;

            @Override
            public void run() {
                if (this.broken) {
                    Log.info((String)"[helper-redis] Retrying subscription...");
                    this.broken = false;
                }
                try (Jedis jedis = HelperRedis.this.getJedis();){
                    try {
                        HelperRedis.this.listener = new PubSubListener();
                        jedis.psubscribe(HelperRedis.this.listener, new byte[][]{"helper-redis-dummy".getBytes(StandardCharsets.UTF_8)});
                    }
                    catch (Exception e) {
                        new RuntimeException("Error subscribing to listener", e).printStackTrace();
                        try {
                            HelperRedis.this.listener.unsubscribe();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        HelperRedis.this.listener = null;
                        this.broken = true;
                    }
                }
                if (this.broken) {
                    Schedulers.async().runLater((Runnable)this, 1L);
                }
            }
        });
        Schedulers.async().runRepeating(() -> {
            PubSubListener listener = this.listener;
            if (listener == null || !listener.isSubscribed()) {
                return;
            }
            for (String channel : this.channels) {
                listener.subscribe(new byte[][]{channel.getBytes(StandardCharsets.UTF_8)});
            }
        }, 2L, 2L).bindWith((TerminableConsumer)this.registry);
        this.messenger = new AbstractMessenger((channel, message) -> {
            try (Jedis jedis = this.getJedis();){
                jedis.publish(channel.getBytes(StandardCharsets.UTF_8), (byte[])message);
            }
        }, channel -> {
            Log.info((String)("[helper-redis] Subscribing to channel: " + channel));
            this.channels.add((String)channel);
            this.listener.subscribe(new byte[][]{channel.getBytes(StandardCharsets.UTF_8)});
        }, channel -> {
            Log.info((String)("[helper-redis] Unsubscribing from channel: " + channel));
            this.channels.remove(channel);
            this.listener.unsubscribe(new byte[][]{channel.getBytes(StandardCharsets.UTF_8)});
        });
    }

    @Override
    @Nonnull
    public JedisPool getJedisPool() {
        Objects.requireNonNull(this.jedisPool, "jedisPool");
        return this.jedisPool;
    }

    @Override
    @Nonnull
    public Jedis getJedis() {
        return this.getJedisPool().getResource();
    }

    public void close() throws Exception {
        if (this.listener != null) {
            this.listener.unsubscribe();
            this.listener = null;
        }
        if (this.jedisPool != null) {
            this.jedisPool.close();
        }
        this.registry.close();
    }

    @Nonnull
    public <T> Channel<T> getChannel(@Nonnull String name, @Nonnull TypeToken<T> type) {
        return this.messenger.getChannel(name, type);
    }

    private final class PubSubListener
    extends BinaryJedisPubSub {
        private Set<String> subscribed = ConcurrentHashMap.newKeySet();

        private PubSubListener() {
        }

        @Override
        public void subscribe(byte[] ... channels) {
            for (byte[] channel : channels) {
                String channelName = new String(channel, StandardCharsets.UTF_8).intern();
                if (!this.subscribed.add(channelName)) continue;
                super.subscribe(new byte[][]{channel});
            }
        }

        @Override
        public void onSubscribe(byte[] channel, int subscribedChannels) {
            Log.info((String)("[helper-redis] Subscribed to channel: " + new String(channel, StandardCharsets.UTF_8)));
        }

        @Override
        public void onUnsubscribe(byte[] channel, int subscribedChannels) {
            String channelName = new String(channel, StandardCharsets.UTF_8);
            Log.info((String)("[helper-redis] Unsubscribed from channel: " + channelName));
            this.subscribed.remove(channelName);
        }

        @Override
        public void onMessage(byte[] channel, byte[] message) {
            String channelName = new String(channel, StandardCharsets.UTF_8);
            try {
                HelperRedis.this.messenger.registerIncomingMessage(channelName, message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

