/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.Closeable;
import java.io.Serializable;
import java.net.URI;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import me.lucko.helper.redis.external.jedisutil.JedisByteHashMap;
import me.lucko.helper.redis.external.jedisutil.JedisURIHelper;
import me.lucko.helper.redis.external.jedisutil.SafeEncoder;
import redis.clients.jedis.AdvancedBinaryJedisCommands;
import redis.clients.jedis.BasicCommands;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryJedisCommands;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.BinaryScriptingCommands;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Client;
import redis.clients.jedis.DebugParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.JedisMonitor;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.MultiKeyBinaryCommands;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.PipelineBlock;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.TransactionBlock;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.exceptions.InvalidURIException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.params.geo.GeoRadiusParam;
import redis.clients.jedis.params.sortedset.ZAddParams;
import redis.clients.jedis.params.sortedset.ZIncrByParams;

public class BinaryJedis
implements BasicCommands,
BinaryJedisCommands,
MultiKeyBinaryCommands,
AdvancedBinaryJedisCommands,
BinaryScriptingCommands,
Closeable {
    protected Client client = null;
    protected Transaction transaction = null;
    protected Pipeline pipeline = null;

    public BinaryJedis() {
        this.client = new Client();
    }

    public BinaryJedis(String host) {
        URI uri = URI.create(host);
        if (uri.getScheme() != null && uri.getScheme().equals("redis")) {
            this.initializeClientFromURI(uri);
        } else {
            this.client = new Client(host);
        }
    }

    public BinaryJedis(String host, int port) {
        this.client = new Client(host, port);
    }

    public BinaryJedis(String host, int port, boolean ssl) {
        this.client = new Client(host, port, ssl);
    }

    public BinaryJedis(String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this.client = new Client(host, port, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public BinaryJedis(String host, int port, int timeout) {
        this.client = new Client(host, port);
        this.client.setConnectionTimeout(timeout);
        this.client.setSoTimeout(timeout);
    }

    public BinaryJedis(String host, int port, int timeout, boolean ssl) {
        this.client = new Client(host, port, ssl);
        this.client.setConnectionTimeout(timeout);
        this.client.setSoTimeout(timeout);
    }

    public BinaryJedis(String host, int port, int timeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this.client = new Client(host, port, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
        this.client.setConnectionTimeout(timeout);
        this.client.setSoTimeout(timeout);
    }

    public BinaryJedis(String host, int port, int connectionTimeout, int soTimeout) {
        this.client = new Client(host, port);
        this.client.setConnectionTimeout(connectionTimeout);
        this.client.setSoTimeout(soTimeout);
    }

    public BinaryJedis(String host, int port, int connectionTimeout, int soTimeout, boolean ssl) {
        this.client = new Client(host, port, ssl);
        this.client.setConnectionTimeout(connectionTimeout);
        this.client.setSoTimeout(soTimeout);
    }

    public BinaryJedis(String host, int port, int connectionTimeout, int soTimeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this.client = new Client(host, port, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
        this.client.setConnectionTimeout(connectionTimeout);
        this.client.setSoTimeout(soTimeout);
    }

    public BinaryJedis(JedisShardInfo shardInfo) {
        this.client = new Client(shardInfo.getHost(), shardInfo.getPort(), shardInfo.getSsl(), shardInfo.getSslSocketFactory(), shardInfo.getSslParameters(), shardInfo.getHostnameVerifier());
        this.client.setConnectionTimeout(shardInfo.getConnectionTimeout());
        this.client.setSoTimeout(shardInfo.getSoTimeout());
        this.client.setPassword(shardInfo.getPassword());
        this.client.setDb(shardInfo.getDb());
    }

    public BinaryJedis(URI uri) {
        this.initializeClientFromURI(uri);
    }

    public BinaryJedis(URI uri, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this.initializeClientFromURI(uri, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public BinaryJedis(URI uri, int timeout) {
        this.initializeClientFromURI(uri);
        this.client.setConnectionTimeout(timeout);
        this.client.setSoTimeout(timeout);
    }

    public BinaryJedis(URI uri, int timeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this.initializeClientFromURI(uri, sslSocketFactory, sslParameters, hostnameVerifier);
        this.client.setConnectionTimeout(timeout);
        this.client.setSoTimeout(timeout);
    }

    public BinaryJedis(URI uri, int connectionTimeout, int soTimeout) {
        this.initializeClientFromURI(uri);
        this.client.setConnectionTimeout(connectionTimeout);
        this.client.setSoTimeout(soTimeout);
    }

    public BinaryJedis(URI uri, int connectionTimeout, int soTimeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this.initializeClientFromURI(uri, sslSocketFactory, sslParameters, hostnameVerifier);
        this.client.setConnectionTimeout(connectionTimeout);
        this.client.setSoTimeout(soTimeout);
    }

    private void initializeClientFromURI(URI uri) {
        int dbIndex;
        if (!JedisURIHelper.isValid(uri)) {
            throw new InvalidURIException(String.format("Cannot open Redis connection due invalid URI. %s", uri.toString()));
        }
        this.client = new Client(uri.getHost(), uri.getPort(), uri.getScheme().equals("rediss"));
        String password = JedisURIHelper.getPassword(uri);
        if (password != null) {
            this.client.auth(password);
            this.client.getStatusCodeReply();
        }
        if ((dbIndex = JedisURIHelper.getDBIndex(uri)) > 0) {
            this.client.select(dbIndex);
            this.client.getStatusCodeReply();
            this.client.setDb(dbIndex);
        }
    }

    private void initializeClientFromURI(URI uri, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        int dbIndex;
        if (!JedisURIHelper.isValid(uri)) {
            throw new InvalidURIException(String.format("Cannot open Redis connection due invalid URI. %s", uri.toString()));
        }
        this.client = new Client(uri.getHost(), uri.getPort(), uri.getScheme().equals("rediss"), sslSocketFactory, sslParameters, hostnameVerifier);
        String password = JedisURIHelper.getPassword(uri);
        if (password != null) {
            this.client.auth(password);
            this.client.getStatusCodeReply();
        }
        if ((dbIndex = JedisURIHelper.getDBIndex(uri)) > 0) {
            this.client.select(dbIndex);
            this.client.getStatusCodeReply();
            this.client.setDb(dbIndex);
        }
    }

    @Override
    public String ping() {
        this.checkIsInMultiOrPipeline();
        this.client.ping();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String set(byte[] key, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.set(key, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String set(byte[] key, byte[] value, byte[] nxxx, byte[] expx, long time) {
        this.checkIsInMultiOrPipeline();
        this.client.set(key, value, nxxx, expx, time);
        return this.client.getStatusCodeReply();
    }

    @Override
    public byte[] get(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.get(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String quit() {
        this.checkIsInMultiOrPipeline();
        this.client.quit();
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long exists(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.exists(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean exists(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.exists(new byte[][]{key});
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Long del(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.del(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Long del(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.del(new byte[][]{key});
        return this.client.getIntegerReply();
    }

    @Override
    public String type(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.type(key);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String flushDB() {
        this.checkIsInMultiOrPipeline();
        this.client.flushDB();
        return this.client.getStatusCodeReply();
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        this.checkIsInMultiOrPipeline();
        this.client.keys(pattern);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public byte[] randomBinaryKey() {
        this.checkIsInMultiOrPipeline();
        this.client.randomKey();
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String rename(byte[] oldkey, byte[] newkey) {
        this.checkIsInMultiOrPipeline();
        this.client.rename(oldkey, newkey);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long renamenx(byte[] oldkey, byte[] newkey) {
        this.checkIsInMultiOrPipeline();
        this.client.renamenx(oldkey, newkey);
        return this.client.getIntegerReply();
    }

    @Override
    public Long dbSize() {
        this.checkIsInMultiOrPipeline();
        this.client.dbSize();
        return this.client.getIntegerReply();
    }

    @Override
    public Long expire(byte[] key, int seconds) {
        this.checkIsInMultiOrPipeline();
        this.client.expire(key, seconds);
        return this.client.getIntegerReply();
    }

    @Override
    @Deprecated
    public Long pexpire(String key, long milliseconds) {
        this.checkIsInMultiOrPipeline();
        this.client.pexpire(key, milliseconds);
        return this.client.getIntegerReply();
    }

    @Override
    public Long expireAt(byte[] key, long unixTime) {
        this.checkIsInMultiOrPipeline();
        this.client.expireAt(key, unixTime);
        return this.client.getIntegerReply();
    }

    @Override
    public Long ttl(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.ttl(key);
        return this.client.getIntegerReply();
    }

    @Override
    public String select(int index) {
        this.checkIsInMultiOrPipeline();
        this.client.select(index);
        String statusCodeReply = this.client.getStatusCodeReply();
        this.client.setDb(index);
        return statusCodeReply;
    }

    @Override
    public Long move(byte[] key, int dbIndex) {
        this.checkIsInMultiOrPipeline();
        this.client.move(key, dbIndex);
        return this.client.getIntegerReply();
    }

    @Override
    public String flushAll() {
        this.checkIsInMultiOrPipeline();
        this.client.flushAll();
        return this.client.getStatusCodeReply();
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.getSet(key, value);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public List<byte[]> mget(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.mget(keys);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Long setnx(byte[] key, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.setnx(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String setex(byte[] key, int seconds, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.setex(key, seconds, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String mset(byte[] ... keysvalues) {
        this.checkIsInMultiOrPipeline();
        this.client.mset(keysvalues);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long msetnx(byte[] ... keysvalues) {
        this.checkIsInMultiOrPipeline();
        this.client.msetnx(keysvalues);
        return this.client.getIntegerReply();
    }

    @Override
    public Long decrBy(byte[] key, long integer) {
        this.checkIsInMultiOrPipeline();
        this.client.decrBy(key, integer);
        return this.client.getIntegerReply();
    }

    @Override
    public Long decr(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.decr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long incrBy(byte[] key, long integer) {
        this.checkIsInMultiOrPipeline();
        this.client.incrBy(key, integer);
        return this.client.getIntegerReply();
    }

    @Override
    public Double incrByFloat(byte[] key, double integer) {
        this.checkIsInMultiOrPipeline();
        this.client.incrByFloat(key, integer);
        String dval = this.client.getBulkReply();
        return dval != null ? new Double(dval) : null;
    }

    @Override
    public Long incr(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.incr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.append(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] substr(byte[] key, int start, int end) {
        this.checkIsInMultiOrPipeline();
        this.client.substr(key, start, end);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long hset(byte[] key, byte[] field, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.hset(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] hget(byte[] key, byte[] field) {
        this.checkIsInMultiOrPipeline();
        this.client.hget(key, field);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long hsetnx(byte[] key, byte[] field, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.hsetnx(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        this.checkIsInMultiOrPipeline();
        this.client.hmset(key, hash);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        this.checkIsInMultiOrPipeline();
        this.client.hmget(key, fields);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Long hincrBy(byte[] key, byte[] field, long value) {
        this.checkIsInMultiOrPipeline();
        this.client.hincrBy(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public Double hincrByFloat(byte[] key, byte[] field, double value) {
        this.checkIsInMultiOrPipeline();
        this.client.hincrByFloat(key, field, value);
        String dval = this.client.getBulkReply();
        return dval != null ? new Double(dval) : null;
    }

    @Override
    public Boolean hexists(byte[] key, byte[] field) {
        this.checkIsInMultiOrPipeline();
        this.client.hexists(key, field);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Long hdel(byte[] key, byte[] ... fields) {
        this.checkIsInMultiOrPipeline();
        this.client.hdel(key, fields);
        return this.client.getIntegerReply();
    }

    @Override
    public Long hlen(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.hlen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> hkeys(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.hkeys(key);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    public List<byte[]> hvals(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.hvals(key);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Map<byte[], byte[]> hgetAll(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.hgetAll(key);
        List<byte[]> flatHash = this.client.getBinaryMultiBulkReply();
        JedisByteHashMap hash = new JedisByteHashMap();
        Iterator<byte[]> iterator = flatHash.iterator();
        while (iterator.hasNext()) {
            hash.put(iterator.next(), iterator.next());
        }
        return hash;
    }

    @Override
    public Long rpush(byte[] key, byte[] ... strings) {
        this.checkIsInMultiOrPipeline();
        this.client.rpush(key, strings);
        return this.client.getIntegerReply();
    }

    @Override
    public Long lpush(byte[] key, byte[] ... strings) {
        this.checkIsInMultiOrPipeline();
        this.client.lpush(key, strings);
        return this.client.getIntegerReply();
    }

    @Override
    public Long llen(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.llen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public List<byte[]> lrange(byte[] key, long start, long end) {
        this.checkIsInMultiOrPipeline();
        this.client.lrange(key, start, end);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public String ltrim(byte[] key, long start, long end) {
        this.checkIsInMultiOrPipeline();
        this.client.ltrim(key, start, end);
        return this.client.getStatusCodeReply();
    }

    @Override
    public byte[] lindex(byte[] key, long index) {
        this.checkIsInMultiOrPipeline();
        this.client.lindex(key, index);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String lset(byte[] key, long index, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.lset(key, index, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long lrem(byte[] key, long count, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.lrem(key, count, value);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] lpop(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.lpop(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public byte[] rpop(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.rpop(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public byte[] rpoplpush(byte[] srckey, byte[] dstkey) {
        this.checkIsInMultiOrPipeline();
        this.client.rpoplpush(srckey, dstkey);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long sadd(byte[] key, byte[] ... members) {
        this.checkIsInMultiOrPipeline();
        this.client.sadd(key, members);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> smembers(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.smembers(key);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long srem(byte[] key, byte[] ... member) {
        this.checkIsInMultiOrPipeline();
        this.client.srem(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] spop(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.spop(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Set<byte[]> spop(byte[] key, long count) {
        this.checkIsInMultiOrPipeline();
        this.client.spop(key, count);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long smove(byte[] srckey, byte[] dstkey, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.smove(srckey, dstkey, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long scard(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.scard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean sismember(byte[] key, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.sismember(key, member);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Set<byte[]> sinter(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sinter(keys);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long sinterstore(byte[] dstkey, byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sinterstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> sunion(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sunion(keys);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long sunionstore(byte[] dstkey, byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sunionstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> sdiff(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sdiff(keys);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long sdiffstore(byte[] dstkey, byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sdiffstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] srandmember(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.srandmember(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public List<byte[]> srandmember(byte[] key, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.srandmember(key, count);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Long zadd(byte[] key, double score, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.zadd(key, score, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zadd(byte[] key, double score, byte[] member, ZAddParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.zadd(key, score, member, params);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        this.checkIsInMultiOrPipeline();
        this.client.zaddBinary(key, scoreMembers);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.zaddBinary(key, scoreMembers, params);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> zrange(byte[] key, long start, long end) {
        this.checkIsInMultiOrPipeline();
        this.client.zrange(key, start, end);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long zrem(byte[] key, byte[] ... members) {
        this.checkIsInMultiOrPipeline();
        this.client.zrem(key, members);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zincrby(byte[] key, double score, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.zincrby(key, score, member);
        String newscore = this.client.getBulkReply();
        return Double.valueOf(newscore);
    }

    @Override
    public Double zincrby(byte[] key, double score, byte[] member, ZIncrByParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.zincrby(key, score, member, params);
        String newscore = this.client.getBulkReply();
        if (newscore == null) {
            return null;
        }
        return Double.valueOf(newscore);
    }

    @Override
    public Long zrank(byte[] key, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.zrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zrevrank(byte[] key, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> zrevrange(byte[] key, long start, long end) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrange(key, start, end);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<Tuple> zrangeWithScores(byte[] key, long start, long end) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeWithScores(key, start, end);
        return this.getBinaryTupledSet();
    }

    @Override
    public Set<Tuple> zrevrangeWithScores(byte[] key, long start, long end) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeWithScores(key, start, end);
        return this.getBinaryTupledSet();
    }

    @Override
    public Long zcard(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.zcard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zscore(byte[] key, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.zscore(key, member);
        String score = this.client.getBulkReply();
        return score != null ? new Double(score) : null;
    }

    public Transaction multi() {
        this.client.multi();
        this.transaction = new Transaction(this.client);
        return this.transaction;
    }

    @Deprecated
    public List<Object> multi(TransactionBlock jedisTransaction) {
        jedisTransaction.setClient(this.client);
        this.client.multi();
        jedisTransaction.execute();
        return jedisTransaction.exec();
    }

    protected void checkIsInMultiOrPipeline() {
        if (this.client.isInMulti()) {
            throw new JedisDataException("Cannot use Jedis when in Multi. Please use Transation or reset jedis state.");
        }
        if (this.pipeline != null && this.pipeline.hasPipelinedResponse()) {
            throw new JedisDataException("Cannot use Jedis when in Pipeline. Please use Pipeline or reset jedis state .");
        }
    }

    public void connect() {
        this.client.connect();
    }

    public void disconnect() {
        this.client.disconnect();
    }

    public void resetState() {
        if (this.client.isConnected()) {
            if (this.transaction != null) {
                this.transaction.clear();
            }
            if (this.pipeline != null) {
                this.pipeline.clear();
            }
            if (this.client.isInWatch()) {
                this.unwatch();
            }
            this.client.resetState();
        }
        this.transaction = null;
        this.pipeline = null;
    }

    @Override
    public String watch(byte[] ... keys) {
        this.client.watch(keys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String unwatch() {
        this.client.unwatch();
        return this.client.getStatusCodeReply();
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public List<byte[]> sort(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> sort(byte[] key, SortingParams sortingParameters) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key, sortingParameters);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> blpop(int timeout, byte[] ... keys) {
        return this.blpop(this.getArgsAddTimeout(timeout, keys));
    }

    private byte[][] getArgsAddTimeout(int timeout, byte[][] keys) {
        int size = keys.length;
        byte[][] args = new byte[size + 1][];
        for (int at = 0; at != size; ++at) {
            args[at] = keys[at];
        }
        args[size] = Protocol.toByteArray(timeout);
        return args;
    }

    @Override
    public Long sort(byte[] key, SortingParams sortingParameters, byte[] dstkey) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key, sortingParameters, dstkey);
        return this.client.getIntegerReply();
    }

    @Override
    public Long sort(byte[] key, byte[] dstkey) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key, dstkey);
        return this.client.getIntegerReply();
    }

    @Override
    public List<byte[]> brpop(int timeout, byte[] ... keys) {
        return this.brpop(this.getArgsAddTimeout(timeout, keys));
    }

    @Override
    @Deprecated
    public List<byte[]> blpop(byte[] arg) {
        return this.blpop(new byte[][]{arg});
    }

    @Override
    @Deprecated
    public List<byte[]> brpop(byte[] arg) {
        return this.brpop(new byte[][]{arg});
    }

    @Override
    public List<byte[]> blpop(byte[] ... args) {
        this.checkIsInMultiOrPipeline();
        this.client.blpop(args);
        this.client.setTimeoutInfinite();
        try {
            List<byte[]> list = this.client.getBinaryMultiBulkReply();
            return list;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public List<byte[]> brpop(byte[] ... args) {
        this.checkIsInMultiOrPipeline();
        this.client.brpop(args);
        this.client.setTimeoutInfinite();
        try {
            List<byte[]> list = this.client.getBinaryMultiBulkReply();
            return list;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public String auth(String password) {
        this.checkIsInMultiOrPipeline();
        this.client.auth(password);
        return this.client.getStatusCodeReply();
    }

    @Deprecated
    public List<Object> pipelined(PipelineBlock jedisPipeline) {
        jedisPipeline.setClient(this.client);
        jedisPipeline.execute();
        return jedisPipeline.syncAndReturnAll();
    }

    public Pipeline pipelined() {
        this.pipeline = new Pipeline();
        this.pipeline.setClient(this.client);
        return this.pipeline;
    }

    @Override
    public Long zcount(byte[] key, double min, double max) {
        return this.zcount(key, Protocol.toByteArray(min), Protocol.toByteArray(max));
    }

    @Override
    public Long zcount(byte[] key, byte[] min, byte[] max) {
        this.checkIsInMultiOrPipeline();
        this.client.zcount(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double min, double max) {
        return this.zrangeByScore(key, Protocol.toByteArray(min), Protocol.toByteArray(max));
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScore(key, min, max);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        return this.zrangeByScore(key, Protocol.toByteArray(min), Protocol.toByteArray(max), offset, count);
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScore(key, min, max, offset, count);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max) {
        return this.zrangeByScoreWithScores(key, Protocol.toByteArray(min), Protocol.toByteArray(max));
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScoreWithScores(key, min, max);
        return this.getBinaryTupledSet();
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        return this.zrangeByScoreWithScores(key, Protocol.toByteArray(min), Protocol.toByteArray(max), offset, count);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScoreWithScores(key, min, max, offset, count);
        return this.getBinaryTupledSet();
    }

    private Set<Tuple> getBinaryTupledSet() {
        this.checkIsInMultiOrPipeline();
        List<byte[]> membersWithScores = this.client.getBinaryMultiBulkReply();
        if (membersWithScores.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<Tuple> set = new LinkedHashSet<Tuple>(membersWithScores.size() / 2, 1.0f);
        Iterator<byte[]> iterator = membersWithScores.iterator();
        while (iterator.hasNext()) {
            set.add(new Tuple(iterator.next(), Double.valueOf(SafeEncoder.encode(iterator.next()))));
        }
        return set;
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min) {
        return this.zrevrangeByScore(key, Protocol.toByteArray(max), Protocol.toByteArray(min));
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScore(key, max, min);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        return this.zrevrangeByScore(key, Protocol.toByteArray(max), Protocol.toByteArray(min), offset, count);
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScore(key, max, min, offset, count);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        return this.zrevrangeByScoreWithScores(key, Protocol.toByteArray(max), Protocol.toByteArray(min));
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        return this.zrevrangeByScoreWithScores(key, Protocol.toByteArray(max), Protocol.toByteArray(min), offset, count);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScoreWithScores(key, max, min);
        return this.getBinaryTupledSet();
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScoreWithScores(key, max, min, offset, count);
        return this.getBinaryTupledSet();
    }

    @Override
    public Long zremrangeByRank(byte[] key, long start, long end) {
        this.checkIsInMultiOrPipeline();
        this.client.zremrangeByRank(key, start, end);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zremrangeByScore(byte[] key, double start, double end) {
        return this.zremrangeByScore(key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    @Override
    public Long zremrangeByScore(byte[] key, byte[] start, byte[] end) {
        this.checkIsInMultiOrPipeline();
        this.client.zremrangeByScore(key, start, end);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zunionstore(byte[] dstkey, byte[] ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zunionstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zunionstore(dstkey, params, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zinterstore(byte[] dstkey, byte[] ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zinterstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zinterstore(dstkey, params, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zlexcount(byte[] key, byte[] min, byte[] max) {
        this.checkIsInMultiOrPipeline();
        this.client.zlexcount(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByLex(key, min, max);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByLex(key, min, max, offset, count);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByLex(key, max, min);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByLex(key, max, min, offset, count);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long zremrangeByLex(byte[] key, byte[] min, byte[] max) {
        this.checkIsInMultiOrPipeline();
        this.client.zremrangeByLex(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public String save() {
        this.client.save();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String bgsave() {
        this.client.bgsave();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String bgrewriteaof() {
        this.client.bgrewriteaof();
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long lastsave() {
        this.client.lastsave();
        return this.client.getIntegerReply();
    }

    @Override
    public String shutdown() {
        String status;
        this.client.shutdown();
        try {
            status = this.client.getStatusCodeReply();
        }
        catch (JedisException ex) {
            status = null;
        }
        return status;
    }

    @Override
    public String info() {
        this.client.info();
        return this.client.getBulkReply();
    }

    @Override
    public String info(String section) {
        this.client.info(section);
        return this.client.getBulkReply();
    }

    public void monitor(JedisMonitor jedisMonitor) {
        this.client.monitor();
        this.client.getStatusCodeReply();
        jedisMonitor.proceed(this.client);
    }

    @Override
    public String slaveof(String host, int port) {
        this.client.slaveof(host, port);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String slaveofNoOne() {
        this.client.slaveofNoOne();
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<byte[]> configGet(byte[] pattern) {
        this.client.configGet(pattern);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public String configResetStat() {
        this.client.configResetStat();
        return this.client.getStatusCodeReply();
    }

    @Override
    public byte[] configSet(byte[] parameter, byte[] value) {
        this.client.configSet(parameter, value);
        return this.client.getBinaryBulkReply();
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    @Override
    public Long strlen(byte[] key) {
        this.client.strlen(key);
        return this.client.getIntegerReply();
    }

    public void sync() {
        this.client.sync();
    }

    @Override
    public Long lpushx(byte[] key, byte[] ... string) {
        this.client.lpushx(key, string);
        return this.client.getIntegerReply();
    }

    @Override
    public Long persist(byte[] key) {
        this.client.persist(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long rpushx(byte[] key, byte[] ... string) {
        this.client.rpushx(key, string);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] echo(byte[] string) {
        this.client.echo(string);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
        this.client.linsert(key, where, pivot, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String debug(DebugParams params) {
        this.client.debug(params);
        return this.client.getStatusCodeReply();
    }

    public Client getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] brpoplpush(byte[] source, byte[] destination, int timeout) {
        this.client.brpoplpush(source, destination, timeout);
        this.client.setTimeoutInfinite();
        try {
            byte[] byArray = this.client.getBinaryBulkReply();
            return byArray;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public Boolean setbit(byte[] key, long offset, boolean value) {
        this.client.setbit(key, offset, value);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Boolean setbit(byte[] key, long offset, byte[] value) {
        this.client.setbit(key, offset, value);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Boolean getbit(byte[] key, long offset) {
        this.client.getbit(key, offset);
        return this.client.getIntegerReply() == 1L;
    }

    public Long bitpos(byte[] key, boolean value) {
        return this.bitpos(key, value, new BitPosParams());
    }

    public Long bitpos(byte[] key, boolean value, BitPosParams params) {
        this.client.bitpos(key, value, params);
        return this.client.getIntegerReply();
    }

    @Override
    public Long setrange(byte[] key, long offset, byte[] value) {
        this.client.setrange(key, offset, value);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] getrange(byte[] key, long startOffset, long endOffset) {
        this.client.getrange(key, startOffset, endOffset);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        this.client.publish(channel, message);
        return this.client.getIntegerReply();
    }

    @Override
    public void subscribe(BinaryJedisPubSub jedisPubSub, byte[] ... channels) {
        this.client.setTimeoutInfinite();
        try {
            jedisPubSub.proceed(this.client, channels);
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public void psubscribe(BinaryJedisPubSub jedisPubSub, byte[] ... patterns) {
        this.client.setTimeoutInfinite();
        try {
            jedisPubSub.proceedWithPatterns(this.client, patterns);
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public Long getDB() {
        return this.client.getDB();
    }

    @Override
    public Object eval(byte[] script, List<byte[]> keys, List<byte[]> args) {
        return this.eval(script, Protocol.toByteArray(keys.size()), BinaryJedis.getParamsWithBinary(keys, args));
    }

    protected static byte[][] getParamsWithBinary(List<byte[]> keys, List<byte[]> args) {
        int i;
        int keyCount = keys.size();
        int argCount = args.size();
        byte[][] params = new byte[keyCount + argCount][];
        for (i = 0; i < keyCount; ++i) {
            params[i] = keys.get(i);
        }
        for (i = 0; i < argCount; ++i) {
            params[keyCount + i] = args.get(i);
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(byte[] script, byte[] keyCount, byte[] ... params) {
        this.client.setTimeoutInfinite();
        try {
            this.client.eval(script, keyCount, params);
            Object object = this.client.getOne();
            return object;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public Object eval(byte[] script, int keyCount, byte[] ... params) {
        return this.eval(script, Protocol.toByteArray(keyCount), params);
    }

    @Override
    public Object eval(byte[] script) {
        return this.eval(script, 0, (byte[][])new byte[0][]);
    }

    @Override
    public Object evalsha(byte[] sha1) {
        return this.evalsha(sha1, 1, new byte[0][]);
    }

    @Override
    public Object evalsha(byte[] sha1, List<byte[]> keys, List<byte[]> args) {
        return this.evalsha(sha1, keys.size(), BinaryJedis.getParamsWithBinary(keys, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evalsha(byte[] sha1, int keyCount, byte[] ... params) {
        this.client.setTimeoutInfinite();
        try {
            this.client.evalsha(sha1, keyCount, params);
            Object object = this.client.getOne();
            return object;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public String scriptFlush() {
        this.client.scriptFlush();
        return this.client.getStatusCodeReply();
    }

    public Long scriptExists(byte[] sha1) {
        byte[][] a = new byte[][]{sha1};
        return this.scriptExists(a).get(0);
    }

    @Override
    public List<Long> scriptExists(byte[] ... sha1) {
        this.client.scriptExists(sha1);
        return this.client.getIntegerMultiBulkReply();
    }

    @Override
    public byte[] scriptLoad(byte[] script) {
        this.client.scriptLoad(script);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String scriptKill() {
        this.client.scriptKill();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String slowlogReset() {
        this.client.slowlogReset();
        return this.client.getBulkReply();
    }

    @Override
    public Long slowlogLen() {
        this.client.slowlogLen();
        return this.client.getIntegerReply();
    }

    @Override
    public List<byte[]> slowlogGetBinary() {
        this.client.slowlogGet();
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> slowlogGetBinary(long entries) {
        this.client.slowlogGet(entries);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Long objectRefcount(byte[] key) {
        this.client.objectRefcount(key);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] objectEncoding(byte[] key) {
        this.client.objectEncoding(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long objectIdletime(byte[] key) {
        this.client.objectIdletime(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitcount(byte[] key) {
        this.client.bitcount(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitcount(byte[] key, long start, long end) {
        this.client.bitcount(key, start, end);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitop(BitOP op, byte[] destKey, byte[] ... srcKeys) {
        this.client.bitop(op, destKey, srcKeys);
        return this.client.getIntegerReply();
    }

    public byte[] dump(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.dump(key);
        return this.client.getBinaryBulkReply();
    }

    public String restore(byte[] key, int ttl, byte[] serializedValue) {
        this.checkIsInMultiOrPipeline();
        this.client.restore(key, ttl, serializedValue);
        return this.client.getStatusCodeReply();
    }

    @Deprecated
    public Long pexpire(byte[] key, int milliseconds) {
        return this.pexpire(key, (long)milliseconds);
    }

    @Override
    public Long pexpire(byte[] key, long milliseconds) {
        this.checkIsInMultiOrPipeline();
        this.client.pexpire(key, milliseconds);
        return this.client.getIntegerReply();
    }

    @Override
    public Long pexpireAt(byte[] key, long millisecondsTimestamp) {
        this.checkIsInMultiOrPipeline();
        this.client.pexpireAt(key, millisecondsTimestamp);
        return this.client.getIntegerReply();
    }

    public Long pttl(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.pttl(key);
        return this.client.getIntegerReply();
    }

    @Deprecated
    public String psetex(byte[] key, int milliseconds, byte[] value) {
        return this.psetex(key, (long)milliseconds, value);
    }

    public String psetex(byte[] key, long milliseconds, byte[] value) {
        this.checkIsInMultiOrPipeline();
        this.client.psetex(key, milliseconds, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String set(byte[] key, byte[] value, byte[] nxxx) {
        this.checkIsInMultiOrPipeline();
        this.client.set(key, value, nxxx);
        return this.client.getStatusCodeReply();
    }

    public String set(byte[] key, byte[] value, byte[] nxxx, byte[] expx, int time) {
        this.checkIsInMultiOrPipeline();
        this.client.set(key, value, nxxx, expx, time);
        return this.client.getStatusCodeReply();
    }

    public String clientKill(byte[] client) {
        this.checkIsInMultiOrPipeline();
        this.client.clientKill(client);
        return this.client.getStatusCodeReply();
    }

    public String clientGetname() {
        this.checkIsInMultiOrPipeline();
        this.client.clientGetname();
        return this.client.getBulkReply();
    }

    public String clientList() {
        this.checkIsInMultiOrPipeline();
        this.client.clientList();
        return this.client.getBulkReply();
    }

    public String clientSetname(byte[] name) {
        this.checkIsInMultiOrPipeline();
        this.client.clientSetname(name);
        return this.client.getBulkReply();
    }

    public List<String> time() {
        this.checkIsInMultiOrPipeline();
        this.client.time();
        return this.client.getMultiBulkReply();
    }

    public String migrate(byte[] host, int port, byte[] key, int destinationDb, int timeout) {
        this.checkIsInMultiOrPipeline();
        this.client.migrate(host, port, key, destinationDb, timeout);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long waitReplicas(int replicas, long timeout) {
        this.checkIsInMultiOrPipeline();
        this.client.waitReplicas(replicas, timeout);
        return this.client.getIntegerReply();
    }

    @Override
    public Long pfadd(byte[] key, byte[] ... elements) {
        this.checkIsInMultiOrPipeline();
        this.client.pfadd(key, elements);
        return this.client.getIntegerReply();
    }

    @Override
    public long pfcount(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.pfcount(key);
        return this.client.getIntegerReply();
    }

    @Override
    public String pfmerge(byte[] destkey, byte[] ... sourcekeys) {
        this.checkIsInMultiOrPipeline();
        this.client.pfmerge(destkey, sourcekeys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long pfcount(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.pfcount(keys);
        return this.client.getIntegerReply();
    }

    public ScanResult<byte[]> scan(byte[] cursor) {
        return this.scan(cursor, new ScanParams());
    }

    public ScanResult<byte[]> scan(byte[] cursor, ScanParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.scan(cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        byte[] newcursor = (byte[])result.get(0);
        List rawResults = (List)result.get(1);
        return new ScanResult<byte[]>(newcursor, rawResults);
    }

    @Override
    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor) {
        return this.hscan(key, cursor, new ScanParams());
    }

    @Override
    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor, ScanParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.hscan(key, cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        byte[] newcursor = (byte[])result.get(0);
        ArrayList results = new ArrayList();
        List rawResults = (List)result.get(1);
        Iterator iterator = rawResults.iterator();
        while (iterator.hasNext()) {
            results.add(new AbstractMap.SimpleEntry(iterator.next(), iterator.next()));
        }
        return new ScanResult<Map.Entry<byte[], byte[]>>(newcursor, results);
    }

    @Override
    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor) {
        return this.sscan(key, cursor, new ScanParams());
    }

    @Override
    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor, ScanParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.sscan(key, cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        byte[] newcursor = (byte[])result.get(0);
        List rawResults = (List)result.get(1);
        return new ScanResult<byte[]>(newcursor, rawResults);
    }

    @Override
    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor) {
        return this.zscan(key, cursor, new ScanParams());
    }

    @Override
    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor, ScanParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.zscan(key, cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        byte[] newcursor = (byte[])result.get(0);
        ArrayList<Tuple> results = new ArrayList<Tuple>();
        List rawResults = (List)result.get(1);
        Iterator iterator = rawResults.iterator();
        while (iterator.hasNext()) {
            results.add(new Tuple((byte[])iterator.next(), Double.valueOf(SafeEncoder.encode((byte[])iterator.next()))));
        }
        return new ScanResult<Tuple>(newcursor, results);
    }

    @Override
    public Long geoadd(byte[] key, double longitude, double latitude, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.geoadd(key, longitude, latitude, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        this.checkIsInMultiOrPipeline();
        this.client.geoadd(key, memberCoordinateMap);
        return this.client.getIntegerReply();
    }

    @Override
    public Double geodist(byte[] key, byte[] member1, byte[] member2) {
        this.checkIsInMultiOrPipeline();
        this.client.geodist(key, member1, member2);
        String dval = this.client.getBulkReply();
        return dval != null ? new Double(dval) : null;
    }

    @Override
    public Double geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        this.client.geodist(key, member1, member2, unit);
        String dval = this.client.getBulkReply();
        return dval != null ? new Double(dval) : null;
    }

    @Override
    public List<byte[]> geohash(byte[] key, byte[] ... members) {
        this.checkIsInMultiOrPipeline();
        this.client.geohash(key, members);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<GeoCoordinate> geopos(byte[] key, byte[] ... members) {
        this.checkIsInMultiOrPipeline();
        this.client.geopos(key, members);
        return BuilderFactory.GEO_COORDINATE_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        this.client.georadius(key, longitude, latitude, radius, unit);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.checkIsInMultiOrPipeline();
        this.client.georadius(key, longitude, latitude, radius, unit, param);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusByMember(key, member, radius, unit);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusByMember(key, member, radius, unit, param);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<byte[]> bitfield(byte[] key, byte[] ... arguments) {
        this.checkIsInMultiOrPipeline();
        this.client.bitfield(key, arguments);
        return this.client.getBinaryMultiBulkReply();
    }

    protected static class SetFromList<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = -2850347066962734052L;
        private final transient List<E> list;

        private SetFromList(List<E> list) {
            if (list == null) {
                throw new NullPointerException("list");
            }
            this.list = list;
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.list.remove(o);
        }

        @Override
        public boolean add(E e) {
            return !this.contains(e) && this.list.add(e);
        }

        @Override
        public Iterator<E> iterator() {
            return this.list.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.list.toArray(a);
        }

        @Override
        public String toString() {
            return this.list.toString();
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            if (c.size() != this.size()) {
                return false;
            }
            return this.containsAll(c);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.list.containsAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.list.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.list.retainAll(c);
        }

        protected static <E> SetFromList<E> of(List<E> list) {
            return new SetFromList<E>(list);
        }
    }
}

