/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.redis.plugin;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import me.lucko.helper.messaging.Messenger;
import me.lucko.helper.plugin.ExtendedJavaPlugin;
import me.lucko.helper.redis.HelperRedis;
import me.lucko.helper.redis.RedisCredentials;
import me.lucko.helper.redis.RedisProvider;
import me.lucko.helper.redis.plugin.JedisWrapper;
import me.lucko.helper.terminable.TerminableConsumer;
import org.bukkit.configuration.ConfigurationSection;

public class RedisPlugin
extends ExtendedJavaPlugin
implements RedisProvider {
    private RedisCredentials globalCredentials;
    private HelperRedis globalRedis;

    protected void enable() {
        this.globalCredentials = RedisCredentials.fromConfig((ConfigurationSection)this.loadConfig("config.yml"));
        this.globalRedis = this.getRedis(this.globalCredentials);
        this.globalRedis.bindWith((TerminableConsumer)this);
        this.provideService(RedisProvider.class, this);
        this.provideService(RedisCredentials.class, this.globalCredentials);
        this.provideService(HelperRedis.class, this.globalRedis);
        this.provideService(Messenger.class, this.globalRedis);
    }

    @Override
    @Nonnull
    public HelperRedis getRedis() {
        return this.globalRedis;
    }

    @Override
    @Nonnull
    public HelperRedis getRedis(@Nonnull RedisCredentials credentials) {
        return CompletableFuture.supplyAsync(() -> new JedisWrapper(credentials)).join();
    }

    @Override
    @Nonnull
    public RedisCredentials getGlobalCredentials() {
        return this.globalCredentials;
    }
}

