/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.redis.plugin;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import me.lucko.helper.Scheduler;
import me.lucko.helper.messaging.AbstractMessenger;
import me.lucko.helper.messaging.Channel;
import me.lucko.helper.redis.HelperRedis;
import me.lucko.helper.redis.RedisCredentials;
import me.lucko.helper.redis.external.commonspool2.impl.GenericObjectPoolConfig;
import me.lucko.helper.terminable.TerminableConsumer;
import me.lucko.helper.terminable.registry.TerminableRegistry;
import me.lucko.helper.utils.Log;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;

public class JedisWrapper
implements HelperRedis {
    private final JedisPool jedisPool;
    private final AbstractMessenger messenger;
    private PubSubListener listener = null;
    private Set<String> channels = new HashSet<String>();
    private TerminableRegistry registry = TerminableRegistry.create();

    public JedisWrapper(@Nonnull RedisCredentials credentials) {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(16);
        this.jedisPool = credentials.getPassword().trim().isEmpty() ? new JedisPool((GenericObjectPoolConfig)config, credentials.getAddress(), credentials.getPort()) : new JedisPool((GenericObjectPoolConfig)config, credentials.getAddress(), credentials.getPort(), 2000, credentials.getPassword());
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.ping();
        }
        Scheduler.runAsync((Runnable)new Runnable(){
            private boolean broken = false;

            @Override
            public void run() {
                if (this.broken) {
                    Log.info((String)"[helper-redis] Retrying subscription...");
                    this.broken = false;
                }
                try (Jedis jedis = JedisWrapper.this.getJedis();){
                    try {
                        JedisWrapper.this.listener = new PubSubListener();
                        jedis.subscribe(JedisWrapper.this.listener, "helper-redis-dummy");
                    }
                    catch (Exception e) {
                        new RuntimeException("Error subscribing to listener", e).printStackTrace();
                        try {
                            JedisWrapper.this.listener.unsubscribe();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        JedisWrapper.this.listener = null;
                        this.broken = true;
                    }
                }
                if (this.broken) {
                    Scheduler.runLaterAsync((Runnable)this, (long)1L);
                }
            }
        });
        Scheduler.runTaskRepeatingAsync(() -> {
            PubSubListener listener = this.listener;
            if (listener == null || !listener.isSubscribed()) {
                return;
            }
            for (String channel : this.channels) {
                listener.subscribe(channel);
            }
        }, (long)2L, (long)2L).bindWith((TerminableConsumer)this.registry);
        this.messenger = new AbstractMessenger((channel, message) -> {
            try (Jedis jedis = this.getJedis();){
                jedis.publish((String)channel, (String)message);
            }
        }, channel -> {
            Log.info((String)("[helper-redis] Subscribing to channel: " + channel));
            this.channels.add((String)channel);
            this.listener.subscribe((String)channel);
        }, channel -> {
            Log.info((String)("[helper-redis] Unsubscribing from channel: " + channel));
            this.channels.remove(channel);
            this.listener.unsubscribe((String)channel);
        });
    }

    @Override
    @Nonnull
    public JedisPool getJedisPool() {
        Preconditions.checkNotNull((Object)this.jedisPool, (Object)"jedisPool");
        return this.jedisPool;
    }

    @Override
    @Nonnull
    public Jedis getJedis() {
        return this.getJedisPool().getResource();
    }

    public boolean terminate() {
        if (this.listener != null) {
            this.listener.unsubscribe();
            this.listener = null;
        }
        if (this.jedisPool != null) {
            this.jedisPool.close();
            return true;
        }
        this.registry.terminate();
        return false;
    }

    @Nonnull
    public <T> Channel<T> getChannel(@Nonnull String name, @Nonnull TypeToken<T> type) {
        return this.messenger.getChannel(name, type);
    }

    private final class PubSubListener
    extends JedisPubSub {
        private Set<String> subscribed = ConcurrentHashMap.newKeySet();

        private PubSubListener() {
        }

        @Override
        public void subscribe(String ... channels) {
            for (String channel : channels) {
                if (!this.subscribed.add(channel)) continue;
                super.subscribe(channel);
            }
        }

        @Override
        public void onSubscribe(String channel, int subscribedChannels) {
            Log.info((String)("[helper-redis] Subscribed to channel: " + channel));
        }

        @Override
        public void onUnsubscribe(String channel, int subscribedChannels) {
            Log.info((String)("[helper-redis] Unsubscribed from channel: " + channel));
            this.subscribed.remove(channel);
        }

        @Override
        public void onMessage(String channel, String message) {
            try {
                JedisWrapper.this.messenger.registerIncomingMessage(channel, message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

