/*
 * This file is part of helper, licensed under the MIT License.
 *
 *  Copyright (c) lucko (Luck) <luck@lucko.me>
 *  Copyright (c) contributors
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in all
 *  copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 *  SOFTWARE.
 */

package me.lucko.helper.redis;

import me.lucko.helper.messaging.Messenger;
import me.lucko.helper.redis.plugin.JedisWrapper;
import me.lucko.helper.terminable.Terminable;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.annotation.Nonnull;

/**
 * Represents an individual redis instance, created by the library.
 */
public interface HelperRedis extends Terminable, Messenger {

    @Nonnull
    static HelperRedis usingJedis(@Nonnull RedisCredentials credentials) {
        return new JedisWrapper(credentials);
    }

    /**
     * Gets the JedisPool instance backing the redis instance
     *
     * @return the JedisPool instance
     */
    @Nonnull
    JedisPool getJedisPool();

    /**
     * Gets a Jedis instance from the JedisPool.
     *
     * @return a jedis instance
     */
    @Nonnull
    Jedis getJedis();

}
