/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.profiles.plugin.external.caffeine.cache;

import me.lucko.helper.profiles.plugin.external.caffeine.cache.CacheLoader;
import me.lucko.helper.profiles.plugin.external.caffeine.cache.Caffeine;
import me.lucko.helper.profiles.plugin.external.caffeine.cache.Expiry;
import me.lucko.helper.profiles.plugin.external.caffeine.cache.SILMS;
import me.lucko.helper.profiles.plugin.external.caffeine.cache.Ticker;
import me.lucko.helper.profiles.plugin.external.caffeine.cache.TimerWheel;

class SILMSA<K, V>
extends SILMS<K, V> {
    final Ticker ticker;
    final Expiry<K, V> expiry;
    final TimerWheel<K, V> timerWheel;
    volatile long expiresAfterAccessNanos;

    SILMSA(Caffeine<K, V> caffeine, CacheLoader<? super K, V> cacheLoader, boolean bl) {
        super(caffeine, cacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.expiry = caffeine.getExpiry(this.isAsync);
        this.timerWheel = caffeine.expiresVariable() ? new TimerWheel(this) : null;
        this.expiresAfterAccessNanos = caffeine.getExpiresAfterAccessNanos();
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final boolean expiresVariable() {
        return this.timerWheel != null;
    }

    @Override
    protected final Expiry<K, V> expiry() {
        return this.expiry;
    }

    @Override
    protected final TimerWheel<K, V> timerWheel() {
        return this.timerWheel;
    }

    @Override
    protected final boolean expiresAfterAccess() {
        return this.timerWheel == null;
    }

    @Override
    protected final long expiresAfterAccessNanos() {
        return this.expiresAfterAccessNanos;
    }

    @Override
    protected final void setExpiresAfterAccessNanos(long l) {
        this.expiresAfterAccessNanos = l;
    }
}

