/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.profiles.plugin.external.caffeine.cache;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import me.lucko.helper.profiles.plugin.external.caffeine.cache.AsyncCacheLoader;

@FunctionalInterface
@ThreadSafe
public interface CacheLoader<K, V>
extends AsyncCacheLoader<K, V> {
    @Nullable
    public V load(@Nonnull K var1) throws Exception;

    @Nonnull
    default public Map<K, V> loadAll(@Nonnull Iterable<? extends K> keys) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    default public CompletableFuture<V> asyncLoad(@Nonnull K key, @Nonnull Executor executor) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(executor);
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.load(key);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, executor);
    }

    @Override
    @Nonnull
    default public CompletableFuture<Map<K, V>> asyncLoadAll(@Nonnull Iterable<? extends K> keys, @Nonnull Executor executor) {
        Objects.requireNonNull(keys);
        Objects.requireNonNull(executor);
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.loadAll(keys);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, executor);
    }

    @Nullable
    default public V reload(@Nonnull K key, @Nonnull V oldValue) throws Exception {
        return this.load(key);
    }

    @Override
    @Nonnull
    default public CompletableFuture<V> asyncReload(@Nonnull K key, @Nonnull V oldValue, @Nonnull Executor executor) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(executor);
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.reload(key, oldValue);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, executor);
    }
}

