/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.profiles.plugin;

import com.google.common.collect.Iterables;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import me.lucko.helper.Events;
import me.lucko.helper.Schedulers;
import me.lucko.helper.profiles.Profile;
import me.lucko.helper.profiles.ProfileRepository;
import me.lucko.helper.profiles.plugin.ImmutableProfile;
import me.lucko.helper.profiles.plugin.external.caffeine.cache.Cache;
import me.lucko.helper.profiles.plugin.external.caffeine.cache.Caffeine;
import me.lucko.helper.promise.Promise;
import me.lucko.helper.sql.Sql;
import me.lucko.helper.terminable.TerminableConsumer;
import me.lucko.helper.terminable.module.TerminableModule;
import me.lucko.helper.utils.Log;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerLoginEvent;

public class HelperProfileRepository
implements ProfileRepository,
TerminableModule {
    private static final String CREATE = "CREATE TABLE IF NOT EXISTS {table} (`uniqueid` BINARY(16) NOT NULL PRIMARY KEY, `name` VARCHAR(16) NOT NULL, `lastupdate` TIMESTAMP NOT NULL)";
    private static final String INSERT = "INSERT INTO {table} VALUES(UNHEX(?), ?, ?) ON DUPLICATE KEY UPDATE `name` = ?, `lastupdate` = ?";
    private static final String SELECT_UID = "SELECT `name`, `lastupdate` FROM {table} WHERE `uniqueid` = UNHEX(?)";
    private static final String SELECT_NAME = "SELECT HEX(`uniqueid`) AS `canonicalid`, `name`, `lastupdate` FROM {table} WHERE `name` = ? ORDER BY `lastupdate` DESC LIMIT 1";
    private static final String SELECT_ALL = "SELECT HEX(`uniqueid`) AS `canonicalid`, `name`, `lastupdate` FROM {table}";
    private static final String SELECT_ALL_RECENT = "SELECT HEX(`uniqueid`) AS `canonicalid`, `name`, `lastupdate` FROM {table} ORDER BY `lastupdate` DESC LIMIT ?";
    private static final String SELECT_ALL_UIDS = "SELECT HEX(`uniqueid`) AS `canonicalid`, `name`, `lastupdate` FROM {table} WHERE `uniqueid` IN %s";
    private static final String SELECT_ALL_NAMES = "SELECT HEX(`uniqueid`) AS `canonicalid`, `name`, `lastupdate` FROM {table} WHERE `name` IN %s GROUP BY `name` ORDER BY `lastupdate` DESC";
    private final Cache<UUID, ImmutableProfile> profileMap = Caffeine.newBuilder().maximumSize(10000L).expireAfterAccess(6L, TimeUnit.HOURS).build();
    private final Sql sql;
    private final String tableName;
    private final int preloadAmount;
    private static final Pattern MINECRAFT_USERNAME_PATTERN = Pattern.compile("^\\w{3,16}$");
    private static final Pattern UUID_PATTERN = Pattern.compile("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})");
    private static final String CANONICAL_UUID_FORM = "$1-$2-$3-$4-$5";

    public HelperProfileRepository(Sql sql, String tableName, int preloadAmount) {
        this.sql = sql;
        this.tableName = tableName;
        this.preloadAmount = preloadAmount;
    }

    public void setup(@Nonnull TerminableConsumer consumer) {
        try (Connection c = this.sql.getConnection();
             Statement s = c.createStatement();){
            s.execute(this.replaceTableName(CREATE));
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        if (this.preloadAmount > 0) {
            Log.info((String)("[helper-profiles] Preloading the most recent " + this.preloadAmount + " entries..."));
            long start = System.currentTimeMillis();
            int found = this.preload(this.preloadAmount);
            long time = System.currentTimeMillis() - start;
            Log.info((String)("[helper-profiles] Preloaded " + found + " profiles into the cache! - took " + time + "ms"));
        }
        Events.subscribe(PlayerLoginEvent.class, (EventPriority)EventPriority.MONITOR).filter(e -> e.getResult() == PlayerLoginEvent.Result.ALLOWED).handler(e -> {
            ImmutableProfile profile = new ImmutableProfile(e.getPlayer().getUniqueId(), e.getPlayer().getName());
            this.updateCache(profile);
            Schedulers.async().run(() -> this.saveProfile(profile));
        }).bindWith(consumer);
    }

    private String replaceTableName(String s) {
        return s.replace("{table}", this.tableName);
    }

    private void updateCache(ImmutableProfile profile) {
        ImmutableProfile existing = this.profileMap.getIfPresent(profile.getUniqueId());
        if (existing == null || existing.getTimestamp() < profile.getTimestamp()) {
            this.profileMap.put(profile.getUniqueId(), profile);
        }
    }

    private void saveProfile(ImmutableProfile profile) {
        try (Connection c = this.sql.getConnection();
             PreparedStatement ps = c.prepareStatement(this.replaceTableName(INSERT));){
            ps.setString(1, HelperProfileRepository.uuidToString(profile.getUniqueId()));
            ps.setString(2, profile.getName().get());
            ps.setTimestamp(3, new Timestamp(profile.getTimestamp()));
            ps.setString(4, profile.getName().get());
            ps.setTimestamp(5, new Timestamp(profile.getTimestamp()));
            ps.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private int preload(int numEntries) {
        int i = 0;
        try (Connection c = this.sql.getConnection();
             PreparedStatement ps = c.prepareStatement(this.replaceTableName(SELECT_ALL_RECENT));){
            ps.setInt(1, numEntries);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String name = rs.getString("name");
                    Timestamp lastUpdate = rs.getTimestamp("lastupdate");
                    String uuidString = rs.getString("canonicalid");
                    UUID uuid = HelperProfileRepository.uuidFromString(uuidString);
                    ImmutableProfile p = new ImmutableProfile(uuid, name, lastUpdate.getTime());
                    this.updateCache(p);
                    ++i;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return i;
    }

    @Nonnull
    public Profile getProfile(@Nonnull UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        Profile profile = this.profileMap.getIfPresent(uniqueId);
        if (profile == null) {
            profile = new ImmutableProfile(uniqueId, null, 0L);
        }
        return profile;
    }

    @Nonnull
    public Optional<Profile> getProfile(@Nonnull String name) {
        Objects.requireNonNull(name, "name");
        for (Profile profile : this.profileMap.asMap().values()) {
            if (!profile.getName().isPresent() || !((String)profile.getName().get()).equalsIgnoreCase(name)) continue;
            return Optional.of(profile);
        }
        return Optional.empty();
    }

    @Nonnull
    public Collection<Profile> getKnownProfiles() {
        return Collections.unmodifiableCollection(this.profileMap.asMap().values());
    }

    @Nonnull
    public Promise<Profile> lookupProfile(@Nonnull UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        Profile profile = this.getProfile(uniqueId);
        if (profile.getName().isPresent()) {
            return Promise.completed((Object)profile);
        }
        return Schedulers.async().supply(() -> {
            try (Connection c = this.sql.getConnection();
                 PreparedStatement ps = c.prepareStatement(this.replaceTableName(SELECT_UID));){
                ps.setString(1, HelperProfileRepository.uuidToString(uniqueId));
                try (ResultSet rs = ps.executeQuery();){
                    if (!rs.next()) return new ImmutableProfile(uniqueId, null, 0L);
                    String name = rs.getString("name");
                    Timestamp lastUpdate = rs.getTimestamp("lastupdate");
                    ImmutableProfile p = new ImmutableProfile(uniqueId, name, lastUpdate.getTime());
                    this.updateCache(p);
                    ImmutableProfile immutableProfile = p;
                    return immutableProfile;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return new ImmutableProfile(uniqueId, null, 0L);
        });
    }

    @Nonnull
    public Promise<Optional<Profile>> lookupProfile(@Nonnull String name) {
        Objects.requireNonNull(name, "name");
        Optional<Profile> profile = this.getProfile(name);
        if (profile.isPresent()) {
            return Promise.completed(profile);
        }
        return Schedulers.async().supply(() -> {
            try (Connection c = this.sql.getConnection();
                 PreparedStatement ps = c.prepareStatement(this.replaceTableName(SELECT_NAME));){
                ps.setString(1, name);
                try (ResultSet rs = ps.executeQuery();){
                    if (!rs.next()) return Optional.empty();
                    String remoteName = rs.getString("name");
                    Timestamp lastUpdate = rs.getTimestamp("lastupdate");
                    String uuidString = rs.getString("canonicalid");
                    UUID uuid = HelperProfileRepository.uuidFromString(uuidString);
                    ImmutableProfile p = new ImmutableProfile(uuid, remoteName, lastUpdate.getTime());
                    this.updateCache(p);
                    Optional<ImmutableProfile> optional = Optional.of(p);
                    return optional;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return Optional.empty();
        });
    }

    @Nonnull
    public Promise<Collection<Profile>> lookupKnownProfiles() {
        return Schedulers.async().supply(() -> {
            HashSet<ImmutableProfile> ret = new HashSet<ImmutableProfile>();
            try (Connection c = this.sql.getConnection();
                 PreparedStatement ps = c.prepareStatement(this.replaceTableName(SELECT_ALL));
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String name = rs.getString("name");
                    Timestamp lastUpdate = rs.getTimestamp("lastupdate");
                    String uuidString = rs.getString("canonicalid");
                    UUID uuid = HelperProfileRepository.uuidFromString(uuidString);
                    ImmutableProfile p = new ImmutableProfile(uuid, name, lastUpdate.getTime());
                    this.updateCache(p);
                    ret.add(p);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return ret;
        });
    }

    @Nonnull
    public Promise<Map<UUID, Profile>> lookupProfiles(@Nonnull Iterable<UUID> uniqueIds) {
        HashSet toFind = new HashSet();
        Iterables.addAll(toFind, uniqueIds);
        HashMap<UUID, Profile> ret = new HashMap<UUID, Profile>();
        Iterator iterator = toFind.iterator();
        while (iterator.hasNext()) {
            UUID u = (UUID)iterator.next();
            Profile profile = this.getProfile(u);
            if (!profile.getName().isPresent()) continue;
            ret.put(u, profile);
            iterator.remove();
        }
        StringBuilder sb = new StringBuilder("(");
        boolean first = true;
        for (UUID uniqueId : toFind) {
            if (uniqueId == null) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append("UNHEX('").append(HelperProfileRepository.uuidToString(uniqueId)).append("')");
            first = false;
        }
        if (first) {
            return Promise.completed(ret);
        }
        sb.append(")");
        return Schedulers.async().supply(() -> {
            try (Connection c = this.sql.getConnection();
                 Statement s = c.createStatement();
                 ResultSet rs = s.executeQuery(this.replaceTableName(String.format(SELECT_ALL_UIDS, sb.toString())));){
                while (rs.next()) {
                    String name = rs.getString("name");
                    Timestamp lastUpdate = rs.getTimestamp("lastupdate");
                    String uuidString = rs.getString("canonicalid");
                    UUID uuid = HelperProfileRepository.uuidFromString(uuidString);
                    ImmutableProfile p = new ImmutableProfile(uuid, name, lastUpdate.getTime());
                    this.updateCache(p);
                    ret.put(uuid, p);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return ret;
        });
    }

    @Nonnull
    public Promise<Map<String, Profile>> lookupProfilesByName(@Nonnull Iterable<String> names) {
        HashSet toFind = new HashSet();
        Iterables.addAll(toFind, names);
        HashMap<String, Profile> ret = new HashMap<String, Profile>();
        Iterator iterator = toFind.iterator();
        while (iterator.hasNext()) {
            String u = (String)iterator.next();
            Optional<Profile> profile = this.getProfile(u);
            if (!profile.isPresent()) continue;
            ret.put(u, profile.get());
            iterator.remove();
        }
        StringBuilder sb = new StringBuilder("(");
        boolean first = true;
        for (String name : names) {
            if (name == null || !HelperProfileRepository.isValidMcUsername(name)) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append("'").append(name).append("'");
            first = false;
        }
        if (first) {
            return Promise.completed(ret);
        }
        sb.append(")");
        return Schedulers.async().supply(() -> {
            try (Connection c = this.sql.getConnection();
                 Statement s = c.createStatement();
                 ResultSet rs = s.executeQuery(this.replaceTableName(String.format(SELECT_ALL_NAMES, sb.toString())));){
                while (rs.next()) {
                    String name = rs.getString("name");
                    Timestamp lastUpdate = rs.getTimestamp("lastupdate");
                    String uuidString = rs.getString("canonicalid");
                    UUID uuid = HelperProfileRepository.uuidFromString(uuidString);
                    ImmutableProfile p = new ImmutableProfile(uuid, name, lastUpdate.getTime());
                    this.updateCache(p);
                    ret.put(name, p);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return ret;
        });
    }

    private static String uuidToString(UUID uuid) {
        return HelperProfileRepository.digits(uuid.getMostSignificantBits() >> 32, 8) + HelperProfileRepository.digits(uuid.getMostSignificantBits() >> 16, 4) + HelperProfileRepository.digits(uuid.getMostSignificantBits(), 4) + HelperProfileRepository.digits(uuid.getLeastSignificantBits() >> 48, 4) + HelperProfileRepository.digits(uuid.getLeastSignificantBits(), 12);
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    private static UUID uuidFromString(String uuid) {
        return UUID.fromString(UUID_PATTERN.matcher(uuid.toLowerCase()).replaceAll(CANONICAL_UUID_FORM));
    }

    private static boolean isValidMcUsername(String s) {
        return MINECRAFT_USERNAME_PATTERN.matcher(s).matches();
    }
}

