/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.profiles.plugin.external.caffeine.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import me.lucko.helper.profiles.plugin.external.caffeine.cache.Policy;
import me.lucko.helper.profiles.plugin.external.caffeine.cache.stats.CacheStats;

@ThreadSafe
public interface Cache<K, V> {
    @CheckForNull
    public V getIfPresent(@Nonnull Object var1);

    @CheckForNull
    public V get(@Nonnull K var1, @Nonnull Function<? super K, ? extends V> var2);

    @Nonnull
    public Map<K, V> getAllPresent(@Nonnull Iterable<?> var1);

    public void put(@Nonnull K var1, @Nonnull V var2);

    public void putAll(@Nonnull Map<? extends K, ? extends V> var1);

    public void invalidate(@Nonnull Object var1);

    public void invalidateAll(@Nonnull Iterable<?> var1);

    public void invalidateAll();

    @Nonnegative
    public long estimatedSize();

    @Nonnull
    public CacheStats stats();

    @Nonnull
    public ConcurrentMap<K, V> asMap();

    public void cleanUp();

    @Nonnull
    public Policy<K, V> policy();
}

