/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.profiles.plugin;

import java.util.UUID;
import java.util.regex.Pattern;

class UuidUtils {
    private static final Pattern MINECRAFT_USERNAME_PATTERN = Pattern.compile("^\\w{3,16}$");
    private static final Pattern UUID_PATTERN = Pattern.compile("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})");
    private static final String CANONICAL_UUID_FORM = "$1-$2-$3-$4-$5";

    UuidUtils() {
    }

    public static String toString(UUID uuid) {
        return UuidUtils.digits(uuid.getMostSignificantBits() >> 32, 8) + UuidUtils.digits(uuid.getMostSignificantBits() >> 16, 4) + UuidUtils.digits(uuid.getMostSignificantBits(), 4) + UuidUtils.digits(uuid.getLeastSignificantBits() >> 48, 4) + UuidUtils.digits(uuid.getLeastSignificantBits(), 12);
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    public static UUID fromString(String uuid) {
        return UUID.fromString(UUID_PATTERN.matcher(uuid.toLowerCase()).replaceAll(CANONICAL_UUID_FORM));
    }

    public static boolean isValidMcUsername(String s) {
        return MINECRAFT_USERNAME_PATTERN.matcher(s).matches();
    }
}

