/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.profiles.plugin;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import me.lucko.helper.Events;
import me.lucko.helper.Scheduler;
import me.lucko.helper.plugin.ExtendedJavaPlugin;
import me.lucko.helper.profiles.Profile;
import me.lucko.helper.profiles.ProfileRepository;
import me.lucko.helper.profiles.plugin.ImmutableProfile;
import me.lucko.helper.profiles.plugin.UuidUtils;
import me.lucko.helper.profiles.plugin.external.caffeine.cache.Cache;
import me.lucko.helper.profiles.plugin.external.caffeine.cache.Caffeine;
import me.lucko.helper.promise.Promise;
import me.lucko.helper.sql.DatabaseCredentials;
import me.lucko.helper.sql.HelperDataSource;
import me.lucko.helper.sql.SqlProvider;
import me.lucko.helper.terminable.TerminableConsumer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerLoginEvent;

public class ProfilesPlugin
extends ExtendedJavaPlugin
implements ProfileRepository {
    private static final String CREATE = "CREATE TABLE IF NOT EXISTS {table} (`uniqueid` BINARY(16) NOT NULL PRIMARY KEY, `name` VARCHAR(16) NOT NULL, `lastupdate` TIMESTAMP NOT NULL)";
    private static final String INSERT = "INSERT INTO {table} VALUES(UNHEX(?), ?, ?) ON DUPLICATE KEY UPDATE `name` = ?, `lastupdate` = ?";
    private static final String SELECT_UID = "SELECT `name`, `lastupdate` FROM {table} WHERE `uniqueid` = UNHEX(?)";
    private static final String SELECT_NAME = "SELECT HEX(`uniqueid`) AS `canonicalid`, `name`, `lastupdate` FROM {table} WHERE `name` = ? ORDER BY `lastupdate` DESC LIMIT 1";
    private static final String SELECT_ALL = "SELECT HEX(`uniqueid`) AS `canonicalid`, `name`, `lastupdate` FROM {table}";
    private static final String SELECT_ALL_RECENT = "SELECT HEX(`uniqueid`) AS `canonicalid`, `name`, `lastupdate` FROM {table} ORDER BY `lastupdate` DESC LIMIT ?";
    private static final String SELECT_ALL_UIDS = "SELECT HEX(`uniqueid`) AS `canonicalid`, `name`, `lastupdate` FROM {table} WHERE `uniqueid` IN %s";
    private static final String SELECT_ALL_NAMES = "SELECT HEX(`uniqueid`) AS `canonicalid`, `name`, `lastupdate` FROM {table} WHERE `name` IN %s GROUP BY `name` ORDER BY `lastupdate` DESC";
    private final Cache<UUID, ImmutableProfile> profileMap = Caffeine.newBuilder().maximumSize(10000L).expireAfterAccess(6L, TimeUnit.HOURS).build();
    private HelperDataSource sql;
    private String tableName;

    protected void enable() {
        SqlProvider sqlProvider = (SqlProvider)this.getService(SqlProvider.class);
        if (sqlProvider == null) {
            throw new RuntimeException("Unable to obtain SqlProvider!");
        }
        YamlConfiguration config = this.loadConfig("config.yml");
        this.sql = config.getBoolean("use-global-credentials", true) ? sqlProvider.getDataSource() : sqlProvider.getDataSource(DatabaseCredentials.fromConfig((ConfigurationSection)config));
        this.tableName = config.getString("table-name", "helper_profiles");
        try (Connection c = this.sql.getConnection();
             Statement s = c.createStatement();){
            s.execute(this.replaceTableName(CREATE));
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        int preloadAmount = config.getInt("preload-amount", 2000);
        if (preloadAmount > 0) {
            this.getLogger().info("Preloading the most recent " + preloadAmount + " entries...");
            long start = System.currentTimeMillis();
            int found = this.preload(preloadAmount);
            long time = System.currentTimeMillis() - start;
            this.getLogger().info("Preloaded " + found + " profiles into the cache! - took " + time + "ms");
        }
        Events.subscribe(PlayerLoginEvent.class, (EventPriority)EventPriority.MONITOR).filter(e -> e.getResult() == PlayerLoginEvent.Result.ALLOWED).handler(e -> {
            ImmutableProfile profile = new ImmutableProfile(e.getPlayer().getUniqueId(), e.getPlayer().getName());
            this.updateCache(profile);
            Scheduler.runAsync(() -> this.saveProfile(profile));
        }).bindWith((TerminableConsumer)this);
        this.provideService(ProfileRepository.class, (Object)this);
    }

    private String replaceTableName(String s) {
        return s.replace("{table}", this.tableName);
    }

    private void updateCache(ImmutableProfile profile) {
        ImmutableProfile existing = this.profileMap.getIfPresent(profile.getUniqueId());
        if (existing == null || existing.getTimestamp() < profile.getTimestamp()) {
            this.profileMap.put(profile.getUniqueId(), profile);
        }
    }

    private void saveProfile(ImmutableProfile profile) {
        try (Connection c = this.sql.getConnection();
             PreparedStatement ps = c.prepareStatement(this.replaceTableName(INSERT));){
            ps.setString(1, UuidUtils.toString(profile.getUniqueId()));
            ps.setString(2, profile.getName().get());
            ps.setTimestamp(3, new Timestamp(profile.getTimestamp()));
            ps.setString(4, profile.getName().get());
            ps.setTimestamp(5, new Timestamp(profile.getTimestamp()));
            ps.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private int preload(int numEntries) {
        int i = 0;
        try (Connection c = this.sql.getConnection();
             PreparedStatement ps = c.prepareStatement(this.replaceTableName(SELECT_ALL_RECENT));){
            ps.setInt(1, numEntries);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String name = rs.getString("name");
                    Timestamp lastUpdate = rs.getTimestamp("lastupdate");
                    String uuidString = rs.getString("canonicalid");
                    UUID uuid = UuidUtils.fromString(uuidString);
                    ImmutableProfile p = new ImmutableProfile(uuid, name, lastUpdate.getTime());
                    this.updateCache(p);
                    ++i;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return i;
    }

    @Nonnull
    public Profile getProfile(@Nonnull UUID uniqueId) {
        Preconditions.checkNotNull((Object)uniqueId, (Object)"uniqueId");
        Profile profile = this.profileMap.getIfPresent(uniqueId);
        if (profile == null) {
            profile = new ImmutableProfile(uniqueId, null, 0L);
        }
        return profile;
    }

    @Nonnull
    public Optional<Profile> getProfile(@Nonnull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        for (Profile profile : this.profileMap.asMap().values()) {
            if (!profile.getName().isPresent() || !((String)profile.getName().get()).equalsIgnoreCase(name)) continue;
            return Optional.of(profile);
        }
        return Optional.empty();
    }

    @Nonnull
    public Collection<Profile> getKnownProfiles() {
        return Collections.unmodifiableCollection(this.profileMap.asMap().values());
    }

    @Nonnull
    public Promise<Profile> lookupProfile(@Nonnull UUID uniqueId) {
        Preconditions.checkNotNull((Object)uniqueId, (Object)"uniqueId");
        Profile profile = this.getProfile(uniqueId);
        if (profile.getName().isPresent()) {
            return Promise.completed((Object)profile);
        }
        return Scheduler.supplyAsync(() -> {
            try (Connection c = this.sql.getConnection();
                 PreparedStatement ps = c.prepareStatement(this.replaceTableName(SELECT_UID));){
                ps.setString(1, UuidUtils.toString(uniqueId));
                try (ResultSet rs = ps.executeQuery();){
                    if (!rs.next()) return new ImmutableProfile(uniqueId, null, 0L);
                    String name = rs.getString("name");
                    Timestamp lastUpdate = rs.getTimestamp("lastupdate");
                    ImmutableProfile p = new ImmutableProfile(uniqueId, name, lastUpdate.getTime());
                    this.updateCache(p);
                    ImmutableProfile immutableProfile = p;
                    return immutableProfile;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return new ImmutableProfile(uniqueId, null, 0L);
        });
    }

    @Nonnull
    public Promise<Optional<Profile>> lookupProfile(@Nonnull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Optional<Profile> profile = this.getProfile(name);
        if (profile.isPresent()) {
            return Promise.completed(profile);
        }
        return Scheduler.supplyAsync(() -> {
            try (Connection c = this.sql.getConnection();
                 PreparedStatement ps = c.prepareStatement(this.replaceTableName(SELECT_NAME));){
                ps.setString(1, name);
                try (ResultSet rs = ps.executeQuery();){
                    if (!rs.next()) return Optional.empty();
                    String remoteName = rs.getString("name");
                    Timestamp lastUpdate = rs.getTimestamp("lastupdate");
                    String uuidString = rs.getString("canonicalid");
                    UUID uuid = UuidUtils.fromString(uuidString);
                    ImmutableProfile p = new ImmutableProfile(uuid, remoteName, lastUpdate.getTime());
                    this.updateCache(p);
                    Optional<ImmutableProfile> optional = Optional.of(p);
                    return optional;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return Optional.empty();
        });
    }

    @Nonnull
    public Promise<Collection<Profile>> lookupKnownProfiles() {
        return Scheduler.supplyAsync(() -> {
            HashSet<ImmutableProfile> ret = new HashSet<ImmutableProfile>();
            try (Connection c = this.sql.getConnection();
                 PreparedStatement ps = c.prepareStatement(this.replaceTableName(SELECT_ALL));
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String name = rs.getString("name");
                    Timestamp lastUpdate = rs.getTimestamp("lastupdate");
                    String uuidString = rs.getString("canonicalid");
                    UUID uuid = UuidUtils.fromString(uuidString);
                    ImmutableProfile p = new ImmutableProfile(uuid, name, lastUpdate.getTime());
                    this.updateCache(p);
                    ret.add(p);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return ret;
        });
    }

    @Nonnull
    public Promise<Map<UUID, Profile>> lookupProfiles(@Nonnull Iterable<UUID> uniqueIds) {
        HashSet toFind = new HashSet();
        Iterables.addAll(toFind, uniqueIds);
        HashMap<UUID, Profile> ret = new HashMap<UUID, Profile>();
        Iterator iterator = toFind.iterator();
        while (iterator.hasNext()) {
            UUID u = (UUID)iterator.next();
            Profile profile = this.getProfile(u);
            if (!profile.getName().isPresent()) continue;
            ret.put(u, profile);
            iterator.remove();
        }
        StringBuilder sb = new StringBuilder("(");
        boolean first = true;
        for (UUID uniqueId : toFind) {
            if (uniqueId == null) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append("UNHEX(`").append(UuidUtils.toString(uniqueId)).append("`)");
            first = false;
        }
        if (first) {
            return Promise.completed(ret);
        }
        sb.append(")");
        return Scheduler.supplyAsync(() -> {
            try (Connection c = this.sql.getConnection();
                 Statement s = c.createStatement();
                 ResultSet rs = s.executeQuery(this.replaceTableName(String.format(SELECT_ALL_UIDS, sb.toString())));){
                while (rs.next()) {
                    String name = rs.getString("name");
                    Timestamp lastUpdate = rs.getTimestamp("lastupdate");
                    String uuidString = rs.getString("canonicalid");
                    UUID uuid = UuidUtils.fromString(uuidString);
                    ImmutableProfile p = new ImmutableProfile(uuid, name, lastUpdate.getTime());
                    this.updateCache(p);
                    ret.put(uuid, p);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return ret;
        });
    }

    @Nonnull
    public Promise<Map<String, Profile>> lookupProfilesByName(@Nonnull Iterable<String> names) {
        HashSet toFind = new HashSet();
        Iterables.addAll(toFind, names);
        HashMap<String, Profile> ret = new HashMap<String, Profile>();
        Iterator iterator = toFind.iterator();
        while (iterator.hasNext()) {
            String u = (String)iterator.next();
            Optional<Profile> profile = this.getProfile(u);
            if (!profile.isPresent()) continue;
            ret.put(u, profile.get());
            iterator.remove();
        }
        StringBuilder sb = new StringBuilder("(");
        boolean first = true;
        for (String name : names) {
            if (name == null || !UuidUtils.isValidMcUsername(name)) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append("`").append(name).append("`");
            first = false;
        }
        if (first) {
            return Promise.completed(ret);
        }
        sb.append(")");
        return Scheduler.supplyAsync(() -> {
            try (Connection c = this.sql.getConnection();
                 Statement s = c.createStatement();
                 ResultSet rs = s.executeQuery(this.replaceTableName(String.format(SELECT_ALL_NAMES, sb.toString())));){
                while (rs.next()) {
                    String name = rs.getString("name");
                    Timestamp lastUpdate = rs.getTimestamp("lastupdate");
                    String uuidString = rs.getString("canonicalid");
                    UUID uuid = UuidUtils.fromString(uuidString);
                    ImmutableProfile p = new ImmutableProfile(uuid, name, lastUpdate.getTime());
                    this.updateCache(p);
                    ret.put(name, p);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return ret;
        });
    }
}

