/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.plugin;

import javax.annotation.Nonnull;
import me.lucko.helper.mongo.Mongo;
import me.lucko.helper.mongo.MongoDatabaseCredentials;
import me.lucko.helper.mongo.MongoProvider;
import me.lucko.helper.mongo.plugin.HelperMongo;
import me.lucko.helper.plugin.ExtendedJavaPlugin;
import me.lucko.helper.terminable.TerminableConsumer;
import org.bukkit.configuration.ConfigurationSection;

public class HelperMongoPlugin
extends ExtendedJavaPlugin
implements MongoProvider {
    private MongoDatabaseCredentials globalCredentials;
    private Mongo globalDataSource;

    protected void enable() {
        this.globalCredentials = MongoDatabaseCredentials.fromConfig((ConfigurationSection)this.loadConfig("config.yml"));
        this.globalDataSource = this.getMongo(this.globalCredentials);
        this.globalDataSource.bindWith((TerminableConsumer)this);
        this.provideService(MongoProvider.class, this);
        this.provideService(MongoDatabaseCredentials.class, this.globalCredentials);
        this.provideService(Mongo.class, this.globalDataSource);
    }

    @Override
    @Nonnull
    public Mongo getMongo() {
        return this.globalDataSource;
    }

    @Override
    @Nonnull
    public Mongo getMongo(@Nonnull MongoDatabaseCredentials credentials) {
        return new HelperMongo(credentials);
    }

    @Override
    @Nonnull
    public MongoDatabaseCredentials getGlobalCredentials() {
        return this.globalCredentials;
    }
}

