/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.plugin;

import javax.annotation.Nonnull;
import me.lucko.helper.mongo.Mongo;
import me.lucko.helper.mongo.MongoDatabaseCredentials;
import me.lucko.helper.mongo.external.mongodriver.MongoClient;
import me.lucko.helper.mongo.external.mongodriver.MongoClientOptions;
import me.lucko.helper.mongo.external.mongodriver.MongoCredential;
import me.lucko.helper.mongo.external.mongodriver.ServerAddress;
import me.lucko.helper.mongo.external.mongodriver.client.MongoDatabase;
import me.lucko.helper.mongo.external.morphia.Datastore;
import me.lucko.helper.mongo.external.morphia.Morphia;

public class HelperMongo
implements Mongo {
    private final MongoClient client;
    private final MongoDatabase database;
    private final Morphia morphia;
    private final Datastore morphiaDatastore;

    public HelperMongo(@Nonnull MongoDatabaseCredentials credentials) {
        MongoCredential mongoCredential = MongoCredential.createCredential(credentials.getUsername(), credentials.getDatabase(), credentials.getPassword().toCharArray());
        this.client = new MongoClient(new ServerAddress(credentials.getAddress(), credentials.getPort()), mongoCredential, MongoClientOptions.builder().build());
        this.database = this.client.getDatabase(credentials.getDatabase());
        this.morphia = new Morphia();
        this.morphiaDatastore = this.morphia.createDatastore(this.client, credentials.getDatabase());
    }

    @Override
    @Nonnull
    public MongoClient getClient() {
        return this.client;
    }

    @Override
    @Nonnull
    public MongoDatabase getDatabase() {
        return this.database;
    }

    @Override
    public MongoDatabase getDatabase(String name) {
        return this.client.getDatabase(name);
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public Morphia getMorphia() {
        return this.morphia;
    }

    @Override
    public Datastore getMorphiaDatastore() {
        return this.morphiaDatastore;
    }

    @Override
    public Datastore getMorphiaDatastore(String name) {
        return this.morphia.createDatastore(this.client, name);
    }
}

