/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.query.validation;

import java.util.List;
import me.lucko.helper.mongo.external.morphia.query.validation.TypeValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.ValidationFailure;

public final class IntegerTypeValidator
extends TypeValidator {
    private static final IntegerTypeValidator INSTANCE = new IntegerTypeValidator();

    private IntegerTypeValidator() {
    }

    public static IntegerTypeValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected boolean appliesTo(Class<?> type) {
        return type == Integer.TYPE || type == Integer.class;
    }

    @Override
    protected void validate(Class<?> type, Object value, List<ValidationFailure> validationFailures) {
        if (Integer.class != value.getClass()) {
            validationFailures.add(new ValidationFailure(String.format("When type is one of the integer types the value should be an Integer.  Type was %s and value '%s' was a %s", type, value, value.getClass())));
        }
    }
}

