/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.query.validation;

import java.util.List;
import me.lucko.helper.mongo.external.morphia.Key;
import me.lucko.helper.mongo.external.morphia.annotations.Entity;
import me.lucko.helper.mongo.external.morphia.query.validation.TypeValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.ValidationFailure;

public final class EntityAnnotatedValueValidator
extends TypeValidator {
    private static final EntityAnnotatedValueValidator INSTANCE = new EntityAnnotatedValueValidator();

    private EntityAnnotatedValueValidator() {
    }

    public static EntityAnnotatedValueValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected boolean appliesTo(Class<?> type) {
        return Key.class.equals(type);
    }

    @Override
    protected void validate(Class<?> type, Object value, List<ValidationFailure> validationFailures) {
        if (value.getClass().getAnnotation(Entity.class) == null) {
            validationFailures.add(new ValidationFailure(String.format("When type is a Key the value should be an annotated entity. Value '%s' was a %s", value, value.getClass())));
        }
    }
}

