/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.query.validation;

import java.util.List;
import me.lucko.helper.mongo.external.morphia.query.validation.TypeValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.ValidationFailure;

public final class DoubleTypeValidator
extends TypeValidator {
    private static final DoubleTypeValidator INSTANCE = new DoubleTypeValidator();

    private DoubleTypeValidator() {
    }

    public static DoubleTypeValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected boolean appliesTo(Class<?> type) {
        return type == Double.TYPE || type == Double.class;
    }

    @Override
    protected void validate(Class<?> type, Object value, List<ValidationFailure> validationFailures) {
        if (!(value instanceof Integer || value instanceof Long || value instanceof Double)) {
            validationFailures.add(new ValidationFailure(String.format("When type is a double the value should be compatible with double.  Type was %s and value '%s' was a %s", type.getCanonicalName(), value, value.getClass().getCanonicalName())));
        }
    }
}

