/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.lucko.helper.mongo.external.mongodriver.BasicDBObject;
import me.lucko.helper.mongo.external.mongodriver.DBObject;
import me.lucko.helper.mongo.external.morphia.internal.PathTarget;
import me.lucko.helper.mongo.external.morphia.mapping.MappedField;
import me.lucko.helper.mongo.external.morphia.mapping.Mapper;
import me.lucko.helper.mongo.external.morphia.query.PushOptions;
import me.lucko.helper.mongo.external.morphia.query.QueryException;
import me.lucko.helper.mongo.external.morphia.query.UpdateOperations;
import me.lucko.helper.mongo.external.morphia.query.UpdateOperator;

public class UpdateOpsImpl<T>
implements UpdateOperations<T> {
    private final Mapper mapper;
    private final Class<T> clazz;
    private Map<String, Map<String, Object>> ops = new HashMap<String, Map<String, Object>>();
    private boolean validateNames = true;
    private boolean isolated;

    public UpdateOpsImpl(Class<T> type, Mapper mapper) {
        this.mapper = mapper;
        this.clazz = type;
    }

    @Override
    @Deprecated
    public UpdateOperations<T> add(String field, Object value) {
        return this.addToSet(field, value);
    }

    @Override
    @Deprecated
    public UpdateOperations<T> add(String field, Object value, boolean addDups) {
        if (value == null) {
            throw new QueryException("Value cannot be null.");
        }
        if (addDups) {
            List<Object> values = value instanceof List ? (List<Object>)value : Collections.singletonList(value);
            this.push(field, values);
        } else {
            List<Object> values = value instanceof List ? (List<Object>)value : Collections.singletonList(value);
            this.addToSet(field, values);
        }
        return this;
    }

    @Override
    @Deprecated
    public UpdateOperations<T> addAll(String field, List<?> values, boolean addDups) {
        if (values == null || values.isEmpty()) {
            throw new QueryException("Values cannot be null or empty.");
        }
        return addDups ? this.push(field, values) : this.addToSet(field, values);
    }

    @Override
    public UpdateOperations<T> addToSet(String field, Object value) {
        if (value == null) {
            throw new QueryException("Value cannot be null.");
        }
        this.add(UpdateOperator.ADD_TO_SET, field, value, true);
        return this;
    }

    @Override
    public UpdateOperations<T> addToSet(String field, List<?> values) {
        if (values == null || values.isEmpty()) {
            throw new QueryException("Values cannot be null or empty.");
        }
        this.add(UpdateOperator.ADD_TO_SET_EACH, field, values, true);
        return this;
    }

    @Override
    public UpdateOperations<T> push(String field, Object value) {
        return this.push(field, value instanceof List ? (List<Object>)value : Collections.singletonList(value), new PushOptions());
    }

    @Override
    public UpdateOperations<T> push(String field, Object value, PushOptions options) {
        return this.push(field, value instanceof List ? (List<Object>)value : Collections.singletonList(value), options);
    }

    @Override
    public UpdateOperations<T> push(String field, List<?> values) {
        return this.push(field, values, new PushOptions());
    }

    @Override
    public UpdateOperations<T> push(String field, List<?> values, PushOptions options) {
        if (values == null || values.isEmpty()) {
            throw new QueryException("Values cannot be null or empty.");
        }
        PathTarget pathTarget = new PathTarget(this.mapper, this.mapper.getMappedClass(this.clazz), field);
        if (!this.validateNames) {
            pathTarget.disableValidation();
        }
        BasicDBObject dbObject = new BasicDBObject(UpdateOperator.EACH.val(), this.mapper.toMongoObject(pathTarget.getTarget(), null, values));
        options.update(dbObject);
        this.addOperation(UpdateOperator.PUSH, pathTarget.translatedPath(), dbObject);
        return this;
    }

    @Override
    public UpdateOperations<T> dec(String field) {
        return this.inc(field, -1);
    }

    @Override
    public UpdateOperations<T> dec(String field, Number value) {
        if (value instanceof Long || value instanceof Integer) {
            return this.inc(field, value.longValue() * -1L);
        }
        if (value instanceof Double || value instanceof Float) {
            return this.inc(field, value.doubleValue() * -1.0);
        }
        throw new IllegalArgumentException("Currently only the following types are allowed: integer, long, double, float.");
    }

    @Override
    public UpdateOperations<T> disableValidation() {
        this.validateNames = false;
        return this;
    }

    @Override
    public UpdateOperations<T> enableValidation() {
        this.validateNames = true;
        return this;
    }

    @Override
    public UpdateOperations<T> inc(String field) {
        return this.inc(field, 1);
    }

    @Override
    public UpdateOperations<T> inc(String field, Number value) {
        if (value == null) {
            throw new QueryException("Value cannot be null.");
        }
        this.add(UpdateOperator.INC, field, value, false);
        return this;
    }

    @Override
    public UpdateOperations<T> isolated() {
        this.isolated = true;
        return this;
    }

    @Override
    public UpdateOperations<T> max(String field, Number value) {
        this.add(UpdateOperator.MAX, field, value, false);
        return this;
    }

    @Override
    public UpdateOperations<T> min(String field, Number value) {
        this.add(UpdateOperator.MIN, field, value, false);
        return this;
    }

    @Override
    public UpdateOperations<T> removeAll(String field, Object value) {
        if (value == null) {
            throw new QueryException("Value cannot be null.");
        }
        this.add(UpdateOperator.PULL, field, value, true);
        return this;
    }

    @Override
    public UpdateOperations<T> removeAll(String field, List<?> values) {
        if (values == null || values.isEmpty()) {
            throw new QueryException("Value cannot be null or empty.");
        }
        this.add(UpdateOperator.PULL_ALL, field, values, true);
        return this;
    }

    @Override
    public UpdateOperations<T> removeFirst(String field) {
        return this.remove(field, true);
    }

    @Override
    public UpdateOperations<T> removeLast(String field) {
        return this.remove(field, false);
    }

    @Override
    public UpdateOperations<T> set(String field, Object value) {
        if (value == null) {
            throw new QueryException("Value cannot be null.");
        }
        this.add(UpdateOperator.SET, field, value, true);
        return this;
    }

    @Override
    public UpdateOperations<T> setOnInsert(String field, Object value) {
        if (value == null) {
            throw new QueryException("Value cannot be null.");
        }
        this.add(UpdateOperator.SET_ON_INSERT, field, value, true);
        return this;
    }

    @Override
    public UpdateOperations<T> unset(String field) {
        this.add(UpdateOperator.UNSET, field, 1, false);
        return this;
    }

    public DBObject getOps() {
        return new BasicDBObject(this.ops);
    }

    public void setOps(DBObject ops) {
        this.ops = (Map)((Object)ops);
    }

    @Override
    public boolean isIsolated() {
        return this.isolated;
    }

    protected void add(UpdateOperator op, String f, Object value, boolean convert) {
        if (value == null) {
            throw new QueryException("Val cannot be null");
        }
        Object val = value;
        PathTarget pathTarget = new PathTarget(this.mapper, this.mapper.getMappedClass(this.clazz), f);
        if (!this.validateNames) {
            pathTarget.disableValidation();
        }
        MappedField mf = pathTarget.getTarget();
        if (convert) {
            val = UpdateOperator.PULL_ALL.equals((Object)op) && value instanceof List ? this.toDBObjList(mf, value) : this.mapper.toMongoObject(mf, null, value);
        }
        if (UpdateOperator.ADD_TO_SET_EACH.equals((Object)op)) {
            val = new BasicDBObject(UpdateOperator.EACH.val(), val);
        }
        this.addOperation(op, pathTarget.translatedPath(), val);
    }

    private void addOperation(UpdateOperator op, String fieldName, Object val) {
        String opString = op.val();
        if (!this.ops.containsKey(opString)) {
            this.ops.put(opString, new LinkedHashMap());
        }
        this.ops.get(opString).put(fieldName, val);
    }

    protected UpdateOperations<T> remove(String fieldExpr, boolean firstNotLast) {
        this.add(UpdateOperator.POP, fieldExpr, firstNotLast ? -1 : 1, false);
        return this;
    }

    protected List<Object> toDBObjList(MappedField mf, List<?> values) {
        ArrayList<Object> list = new ArrayList<Object>(values.size());
        for (Object obj : values) {
            list.add(this.mapper.toMongoObject(mf, null, obj));
        }
        return list;
    }
}

