/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.query;

import me.lucko.helper.mongo.external.mongodriver.BasicDBObjectBuilder;
import me.lucko.helper.mongo.external.mongodriver.DBObject;
import me.lucko.helper.mongo.external.morphia.geo.CoordinateReferenceSystem;
import me.lucko.helper.mongo.external.morphia.geo.Geometry;
import me.lucko.helper.mongo.external.morphia.geo.GeometryQueryConverter;
import me.lucko.helper.mongo.external.morphia.geo.NamedCoordinateReferenceSystemConverter;
import me.lucko.helper.mongo.external.morphia.query.FieldCriteria;
import me.lucko.helper.mongo.external.morphia.query.FilterOperator;
import me.lucko.helper.mongo.external.morphia.query.QueryImpl;

class StandardGeoFieldCriteria
extends FieldCriteria {
    private final Integer maxDistanceMeters;
    private final DBObject geometryAsDBObject;
    private CoordinateReferenceSystem crs;

    StandardGeoFieldCriteria(QueryImpl<?> query, String field, FilterOperator operator, Geometry value, Integer maxDistanceMeters, CoordinateReferenceSystem crs) {
        this(query, field, operator, value, maxDistanceMeters);
        this.crs = crs;
    }

    StandardGeoFieldCriteria(QueryImpl<?> query, String field, FilterOperator operator, Geometry value, Integer maxDistanceMeters) {
        super(query, field, operator, value);
        this.maxDistanceMeters = maxDistanceMeters;
        GeometryQueryConverter geometryQueryConverter = new GeometryQueryConverter(query.getDatastore().getMapper());
        this.geometryAsDBObject = (DBObject)geometryQueryConverter.encode(value, null);
    }

    @Override
    public void addTo(DBObject obj) {
        BasicDBObjectBuilder query;
        FilterOperator operator = this.getOperator();
        switch (operator) {
            case NEAR: {
                if (this.maxDistanceMeters != null) {
                    this.geometryAsDBObject.put("$maxDistance", this.maxDistanceMeters);
                }
                query = BasicDBObjectBuilder.start(FilterOperator.NEAR.val(), this.geometryAsDBObject);
                break;
            }
            case GEO_WITHIN: 
            case INTERSECTS: {
                query = BasicDBObjectBuilder.start(operator.val(), this.geometryAsDBObject);
                if (this.crs == null) break;
                ((DBObject)this.geometryAsDBObject.get("$geometry")).put("crs", new NamedCoordinateReferenceSystemConverter().encode(this.crs));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Operator %s not supported for geo-query", operator.val()));
            }
        }
        obj.put(this.getField(), query.get());
    }
}

