/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.mapping.lazy.proxy;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import me.lucko.helper.mongo.external.morphia.Datastore;
import me.lucko.helper.mongo.external.morphia.Key;
import me.lucko.helper.mongo.external.morphia.mapping.lazy.proxy.AbstractReference;
import me.lucko.helper.mongo.external.morphia.mapping.lazy.proxy.ProxiedEntityReferenceMap;

public class MapObjectReference
extends AbstractReference
implements ProxiedEntityReferenceMap {
    private static final long serialVersionUID = 1L;
    private final HashMap<Object, Key<?>> keyMap;

    public MapObjectReference(Datastore datastore, Map mapToProxy, Class referenceObjClass, boolean ignoreMissing) {
        super(datastore, referenceObjClass, ignoreMissing);
        this.object = mapToProxy;
        this.keyMap = new LinkedHashMap();
    }

    @Override
    public Map<Object, Key<?>> __getReferenceMap() {
        return this.keyMap;
    }

    public void __put(Object key, Key k) {
        this.keyMap.put(key, k);
    }

    @Override
    protected void beforeWriteObject() {
        if (this.__isFetched()) {
            this.syncKeys();
            ((Map)this.object).clear();
        }
    }

    @Override
    protected Object fetch() {
        Map m = (Map)this.object;
        m.clear();
        for (Map.Entry<Object, Key<?>> e : this.keyMap.entrySet()) {
            Key<?> entityKey = e.getValue();
            m.put(e.getKey(), this.fetch(entityKey));
        }
        return m;
    }

    private void syncKeys() {
        Datastore ds = this.getDatastore();
        this.keyMap.clear();
        Map map = (Map)this.object;
        for (Map.Entry e : map.entrySet()) {
            this.keyMap.put(e.getKey(), ds.getKey(e.getValue()));
        }
    }
}

