/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.logging.jdk;

import java.util.logging.Level;
import me.lucko.helper.mongo.external.morphia.logging.Logger;

public class JDKLogger
implements Logger {
    private final transient java.util.logging.Logger logger;

    public JDKLogger(Class c) {
        this.logger = java.util.logging.Logger.getLogger(c.getName());
    }

    @Override
    public void debug(String msg) {
        this.log(Level.FINE, msg, new Object[0]);
    }

    @Override
    public void debug(String format, Object ... arg) {
        this.log(Level.FINE, format, arg);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.log(Level.FINE, msg, t);
    }

    @Override
    public void error(String msg) {
        this.log(Level.SEVERE, msg, new Object[0]);
    }

    @Override
    public void error(String format, Object ... arg) {
        this.log(Level.SEVERE, format, arg);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.log(Level.SEVERE, msg, t);
    }

    @Override
    public void info(String msg) {
        this.log(Level.INFO, msg, new Object[0]);
    }

    @Override
    public void info(String format, Object ... arg) {
        this.log(Level.INFO, format, arg);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.log(Level.INFO, msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }

    @Override
    public boolean isWarningEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public void trace(String msg) {
        this.log(Level.FINER, msg, new Object[0]);
    }

    @Override
    public void trace(String format, Object ... arg) {
        this.log(Level.FINER, format, arg);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.log(Level.FINER, msg, t);
    }

    @Override
    public void warning(String msg) {
        this.log(Level.WARNING, msg, new Object[0]);
    }

    @Override
    public void warning(String format, Object ... arg) {
        this.log(Level.WARNING, format, arg);
    }

    @Override
    public void warning(String msg, Throwable t) {
        this.log(Level.WARNING, msg, t);
    }

    protected String[] getCaller() {
        StackTraceElement ste;
        String fc;
        int i;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        String loggerClassname = this.getClass().getName();
        for (i = 0; i < stack.length && !(fc = (ste = stack[i]).getClassName()).equals(loggerClassname); ++i) {
        }
        ++i;
        while (i < stack.length) {
            ste = stack[i];
            fc = ste.getClassName();
            if (!fc.equals(loggerClassname)) {
                String callerMethod = ste.getMethodName();
                String callerName = fc;
                return new String[]{callerName, callerMethod};
            }
            ++i;
        }
        return new String[]{"", ""};
    }

    protected void log(Level l, String f, Object ... a) {
        if (this.logger.isLoggable(l)) {
            String[] callerInfo = this.getCaller();
            this.logger.logp(l, callerInfo[0], callerInfo[1], f, a);
        }
    }

    protected void log(Level l, String m, Throwable t) {
        if (this.logger.isLoggable(l)) {
            String[] callerInfo = this.getCaller();
            this.logger.logp(l, callerInfo[0], callerInfo[1], m, t);
        }
    }
}

