/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.geo;

import me.lucko.helper.mongo.external.morphia.geo.Geometry;
import me.lucko.helper.mongo.external.morphia.geo.GeometryCollection;
import me.lucko.helper.mongo.external.morphia.geo.LineString;
import me.lucko.helper.mongo.external.morphia.geo.MultiLineString;
import me.lucko.helper.mongo.external.morphia.geo.MultiPoint;
import me.lucko.helper.mongo.external.morphia.geo.MultiPolygon;
import me.lucko.helper.mongo.external.morphia.geo.Point;
import me.lucko.helper.mongo.external.morphia.geo.Polygon;

public final class GeoJson {
    private GeoJson() {
    }

    public static Point point(double latitude, double longitude) {
        return new Point(latitude, longitude);
    }

    public static Polygon polygon(Point ... points) {
        LineString exteriorBoundary = GeoJson.lineString(points);
        GeoJson.ensurePolygonIsClosed(exteriorBoundary);
        return new Polygon(exteriorBoundary, new LineString[0]);
    }

    public static LineString lineString(Point ... points) {
        return new LineString(points);
    }

    private static void ensurePolygonIsClosed(LineString points) {
        int size = points.getCoordinates().size();
        if (size > 0 && !points.getCoordinates().get(0).equals(points.getCoordinates().get(size - 1))) {
            throw new IllegalArgumentException("A polygon requires the starting point to be the same as the end to ensure a closed area");
        }
    }

    public static Polygon polygon(LineString exteriorBoundary, LineString ... interiorBoundaries) {
        GeoJson.ensurePolygonIsClosed(exteriorBoundary);
        for (LineString boundary : interiorBoundaries) {
            GeoJson.ensurePolygonIsClosed(boundary);
        }
        return new Polygon(exteriorBoundary, interiorBoundaries);
    }

    public static MultiPoint multiPoint(Point ... points) {
        return new MultiPoint(points);
    }

    public static MultiLineString multiLineString(LineString ... lines) {
        return new MultiLineString(lines);
    }

    public static MultiPolygon multiPolygon(Polygon ... polygons) {
        return new MultiPolygon(polygons);
    }

    public static GeometryCollection geometryCollection(Geometry ... geometries) {
        return new GeometryCollection(geometries);
    }
}

