/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.dao;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.lucko.helper.mongo.external.mongodriver.DBCollection;
import me.lucko.helper.mongo.external.mongodriver.MongoClient;
import me.lucko.helper.mongo.external.mongodriver.WriteConcern;
import me.lucko.helper.mongo.external.mongodriver.WriteResult;
import me.lucko.helper.mongo.external.morphia.Datastore;
import me.lucko.helper.mongo.external.morphia.DatastoreImpl;
import me.lucko.helper.mongo.external.morphia.InsertOptions;
import me.lucko.helper.mongo.external.morphia.Key;
import me.lucko.helper.mongo.external.morphia.Morphia;
import me.lucko.helper.mongo.external.morphia.dao.DAO;
import me.lucko.helper.mongo.external.morphia.query.FindOptions;
import me.lucko.helper.mongo.external.morphia.query.Query;
import me.lucko.helper.mongo.external.morphia.query.QueryResults;
import me.lucko.helper.mongo.external.morphia.query.UpdateOperations;
import me.lucko.helper.mongo.external.morphia.query.UpdateResults;

public class BasicDAO<T, K>
implements DAO<T, K> {
    @Deprecated
    protected Class<T> entityClazz;
    @Deprecated
    protected DatastoreImpl ds;

    public BasicDAO(Class<T> entityClass, MongoClient mongoClient, Morphia morphia, String dbName) {
        this.initDS(mongoClient, morphia, dbName);
        this.initType(entityClass);
    }

    public BasicDAO(Class<T> entityClass, Datastore ds) {
        this.ds = (DatastoreImpl)ds;
        this.initType(entityClass);
    }

    protected BasicDAO(MongoClient mongoClient, Morphia morphia, String dbName) {
        this.initDS(mongoClient, morphia, dbName);
        this.initType((Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]);
    }

    protected BasicDAO(Datastore ds) {
        this.ds = (DatastoreImpl)ds;
        this.initType((Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]);
    }

    @Override
    public long count() {
        return this.ds.getCount(this.entityClazz);
    }

    @Override
    public long count(String key, Object value) {
        return this.count(this.ds.find(this.entityClazz).filter(key, value));
    }

    @Override
    public long count(Query<T> query) {
        return this.ds.getCount(query);
    }

    @Override
    public Query<T> createQuery() {
        return this.ds.find(this.entityClazz);
    }

    @Override
    public UpdateOperations<T> createUpdateOperations() {
        return this.ds.createUpdateOperations(this.entityClazz);
    }

    @Override
    public WriteResult delete(T entity) {
        return this.ds.delete(entity);
    }

    @Override
    public WriteResult delete(T entity, WriteConcern wc) {
        return this.ds.delete(entity, wc);
    }

    @Override
    public WriteResult deleteById(K id) {
        return this.ds.delete(this.entityClazz, id);
    }

    @Override
    public WriteResult deleteByQuery(Query<T> query) {
        return this.ds.delete(query);
    }

    @Override
    public void ensureIndexes() {
        this.ds.ensureIndexes(this.entityClazz);
    }

    @Override
    public boolean exists(String key, Object value) {
        return this.exists(this.ds.find(this.entityClazz).filter(key, value));
    }

    @Override
    public boolean exists(Query<T> query) {
        return query.get(new FindOptions().limit(1)) != null;
    }

    @Override
    public QueryResults<T> find() {
        return this.createQuery();
    }

    @Override
    public QueryResults<T> find(Query<T> query) {
        return query;
    }

    @Override
    public List<K> findIds() {
        return this.keysToIds(this.ds.find(this.entityClazz).asKeyList());
    }

    @Override
    public List<K> findIds(String key, Object value) {
        return this.keysToIds(this.ds.find(this.entityClazz).filter(key, value).asKeyList());
    }

    @Override
    public List<K> findIds(Query<T> query) {
        return this.keysToIds(query.asKeyList());
    }

    @Override
    public T findOne(String key, Object value) {
        return this.ds.find(this.entityClazz).filter(key, value).get();
    }

    @Override
    public T findOne(Query<T> query) {
        return query.get();
    }

    @Override
    public Key<T> findOneId() {
        return this.findOneId(this.ds.find(this.entityClazz));
    }

    @Override
    public Key<T> findOneId(String key, Object value) {
        return this.findOneId(this.ds.find(this.entityClazz).filter(key, value));
    }

    @Override
    public Key<T> findOneId(Query<T> query) {
        Iterator keys = query.fetchKeys().iterator();
        return keys.hasNext() ? (Key)keys.next() : null;
    }

    @Override
    public T get(K id) {
        return this.ds.get(this.entityClazz, id);
    }

    @Override
    public DBCollection getCollection() {
        return this.ds.getCollection((Class)this.entityClazz);
    }

    @Override
    public Datastore getDatastore() {
        return this.ds;
    }

    @Override
    public Class<T> getEntityClass() {
        return this.entityClazz;
    }

    @Override
    public Key<T> save(T entity) {
        return this.ds.save(entity);
    }

    @Override
    public Key<T> save(T entity, WriteConcern wc) {
        return this.ds.save(entity, new InsertOptions().writeConcern(wc));
    }

    @Override
    public UpdateResults update(Query<T> query, UpdateOperations<T> ops) {
        return this.ds.update(query, ops);
    }

    @Override
    public UpdateResults updateFirst(Query<T> query, UpdateOperations<T> ops) {
        return this.ds.updateFirst(query, ops);
    }

    @Deprecated
    public DatastoreImpl getDs() {
        return this.ds;
    }

    @Deprecated
    public Class<T> getEntityClazz() {
        return this.entityClazz;
    }

    protected void initDS(MongoClient mongoClient, Morphia mor, String db) {
        this.ds = (DatastoreImpl)mor.createDatastore(mongoClient, db);
    }

    protected void initType(Class<T> type) {
        this.entityClazz = type;
        this.ds.getMapper().addMappedClass(type);
    }

    protected List<?> keysToIds(List<Key<T>> keys) {
        ArrayList<Object> ids = new ArrayList<Object>(keys.size() * 2);
        for (Key<T> key : keys) {
            ids.add(key.getId());
        }
        return ids;
    }
}

