/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.converters;

import java.util.Arrays;
import me.lucko.helper.mongo.external.morphia.mapping.MappedField;
import me.lucko.helper.mongo.external.morphia.mapping.Mapper;

public abstract class TypeConverter {
    private Mapper mapper;
    private Class[] supportedTypes;

    protected TypeConverter() {
    }

    protected TypeConverter(Class ... types) {
        this.supportedTypes = this.copy(types);
    }

    public final Object decode(Class targetClass, Object fromDBObject) {
        return this.decode(targetClass, fromDBObject, null);
    }

    public abstract Object decode(Class<?> var1, Object var2, MappedField var3);

    public final Object encode(Object value) {
        return this.encode(value, null);
    }

    public Object encode(Object value, MappedField optionalExtraInfo) {
        return value;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    @Deprecated
    public Class[] getSupportTypes() {
        return this.copy(this.supportedTypes);
    }

    @Deprecated
    public void setSupportTypes(Class[] supportTypes) {
        this.supportedTypes = this.copy(supportTypes);
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass());
    }

    protected boolean isSupported(Class<?> c, MappedField optionalExtraInfo) {
        return false;
    }

    protected boolean oneOf(Class f, Class ... classes) {
        return this.oneOfClasses(f, classes);
    }

    protected boolean oneOfClasses(Class f, Class[] classes) {
        for (Class c : classes) {
            if (!c.equals(f)) continue;
            return true;
        }
        return false;
    }

    Class[] copy(Class[] array) {
        return array == null ? null : Arrays.copyOf(array, array.length);
    }

    final Class[] getSupportedTypes() {
        return this.copy(this.supportedTypes);
    }

    public void setSupportedTypes(Class[] supportedTypes) {
        this.supportedTypes = this.copy(supportedTypes);
    }

    final boolean canHandle(Class c) {
        return this.isSupported(c, null);
    }

    final boolean canHandle(MappedField mf) {
        return this.isSupported(mf.getType(), mf);
    }
}

