/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.converters;

import java.util.LinkedHashMap;
import java.util.Map;
import me.lucko.helper.mongo.external.morphia.converters.TypeConverter;
import me.lucko.helper.mongo.external.morphia.mapping.MappedField;
import me.lucko.helper.mongo.external.morphia.utils.IterHelper;
import me.lucko.helper.mongo.external.morphia.utils.ReflectionUtils;

public class MapOfValuesConverter
extends TypeConverter {
    public Object decode(Class targetClass, Object fromDBObject, final MappedField mf) {
        if (fromDBObject == null) {
            return null;
        }
        final Map values = this.getMapper().getOptions().getObjectFactory().createMap(mf);
        new IterHelper<Object, Object>().loopMap(fromDBObject, new IterHelper.MapIterCallback<Object, Object>(){

            @Override
            public void eval(Object k, Object val) {
                Object objKey = MapOfValuesConverter.this.getMapper().getConverters().decode(mf.getMapKeyClass(), k, mf);
                values.put(objKey, val != null ? MapOfValuesConverter.this.getMapper().getConverters().decode(mf.getSubClass(), val, mf) : null);
            }
        });
        return values;
    }

    @Override
    public Object encode(Object value, MappedField mf) {
        if (value == null) {
            return null;
        }
        Map map = (Map)value;
        if (!map.isEmpty() || this.getMapper().getOptions().isStoreEmpties()) {
            LinkedHashMap<String, Object> mapForDb = new LinkedHashMap<String, Object>();
            for (Map.Entry entry : map.entrySet()) {
                String strKey = this.getMapper().getConverters().encode(entry.getKey()).toString();
                mapForDb.put(strKey, this.getMapper().getConverters().encode(entry.getValue()));
            }
            return mapForDb;
        }
        return null;
    }

    @Override
    protected boolean isSupported(Class<?> c, MappedField optionalExtraInfo) {
        if (optionalExtraInfo != null) {
            return optionalExtraInfo.isMap();
        }
        return ReflectionUtils.implementsInterface(c, Map.class);
    }
}

