/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.converters;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import me.lucko.helper.mongo.external.morphia.converters.EnumConverter;
import me.lucko.helper.mongo.external.morphia.converters.SimpleValueConverter;
import me.lucko.helper.mongo.external.morphia.converters.TypeConverter;
import me.lucko.helper.mongo.external.morphia.mapping.MappedField;

public class EnumSetConverter
extends TypeConverter
implements SimpleValueConverter {
    private final EnumConverter ec = new EnumConverter();

    public EnumSetConverter() {
        super(EnumSet.class);
    }

    public Object decode(Class targetClass, Object fromDBObject, MappedField optionalExtraInfo) {
        if (fromDBObject == null) {
            return null;
        }
        Class enumType = optionalExtraInfo.getSubClass();
        List l = (List)fromDBObject;
        if (l.isEmpty()) {
            return EnumSet.noneOf(enumType);
        }
        ArrayList<Object> enums = new ArrayList<Object>();
        for (Object object : l) {
            enums.add(this.ec.decode(enumType, object));
        }
        return EnumSet.copyOf(enums);
    }

    @Override
    public Object encode(Object value, MappedField optionalExtraInfo) {
        Object[] array;
        if (value == null) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        EnumSet s = (EnumSet)value;
        for (Object anArray : array = s.toArray()) {
            values.add(this.ec.encode(anArray));
        }
        return values;
    }
}

