/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.converters;

import java.util.List;
import me.lucko.helper.mongo.external.morphia.converters.SimpleValueConverter;
import me.lucko.helper.mongo.external.morphia.converters.TypeConverter;
import me.lucko.helper.mongo.external.morphia.mapping.MappedField;
import me.lucko.helper.mongo.external.morphia.utils.ReflectionUtils;

public class DoubleConverter
extends TypeConverter
implements SimpleValueConverter {
    public DoubleConverter() {
        super(Double.TYPE, Double.class, double[].class, Double[].class);
    }

    public Object decode(Class targetClass, Object val, MappedField optionalExtraInfo) {
        if (val == null) {
            return null;
        }
        if (val instanceof Double) {
            return val;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        if (val instanceof List) {
            Class<?> type = targetClass.isArray() ? targetClass.getComponentType() : targetClass;
            return ReflectionUtils.convertToArray(type, (List)val);
        }
        return Double.parseDouble(val.toString());
    }
}

